/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.file.remote.RemoteFileConsumer;
import org.apache.camel.component.file.remote.RemoteFileExchange;
import org.apache.camel.component.file.remote.SftpEndpoint;
import org.apache.camel.component.file.remote.SftpUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SftpConsumer
extends RemoteFileConsumer<RemoteFileExchange> {
    private final SftpEndpoint endpoint;
    private ChannelSftp channel;
    private Session session;

    public SftpConsumer(SftpEndpoint endpoint, Processor processor, Session session) {
        super(endpoint, processor);
        this.endpoint = endpoint;
        this.session = session;
    }

    public SftpConsumer(SftpEndpoint endpoint, Processor processor, Session session, ScheduledExecutorService executor) {
        super(endpoint, processor, executor);
        this.endpoint = endpoint;
        this.session = session;
    }

    protected void doStart() throws Exception {
        this.log.info((Object)"Starting");
        super.doStart();
    }

    protected void doStop() throws Exception {
        this.log.info((Object)"Stopping");
        try {
            this.disconnect();
        }
        catch (Exception e) {
            this.log.warn((Object)("Exception occured during disconecting from " + this.remoteServer() + ". " + e.getClass().getCanonicalName() + " message: " + e.getMessage()));
        }
        super.doStop();
    }

    protected void connectIfNecessary() throws JSchException {
        if (this.channel == null || !this.channel.isConnected()) {
            if (this.session == null || !this.session.isConnected()) {
                this.log.trace((Object)"Session isn't connected, trying to recreate and connect.");
                this.session = this.endpoint.createSession();
                this.session.connect();
            }
            this.log.trace((Object)"Channel isn't connected, trying to recreate and connect.");
            this.channel = this.endpoint.createChannelSftp(this.session);
            this.channel.connect();
            this.log.info((Object)("Connected to " + this.remoteServer()));
        }
    }

    protected void disconnect() throws JSchException {
        this.log.debug((Object)("Disconnecting from " + this.remoteServer()));
        if (this.session != null) {
            this.session.disconnect();
        }
        if (this.channel != null) {
            this.channel.disconnect();
        }
    }

    protected void poll() throws Exception {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Polling " + this.endpoint.getConfiguration()));
        }
        this.connectIfNecessary();
        try {
            String fileName = this.endpoint.getConfiguration().getFile();
            if (this.endpoint.getConfiguration().isDirectory()) {
                this.pollDirectory(fileName);
            } else {
                int index = fileName.lastIndexOf(47);
                if (index > -1) {
                    this.channel.cd(fileName.substring(0, index));
                }
                Vector files = this.channel.ls(fileName.substring(index + 1));
                ChannelSftp.LsEntry file = (ChannelSftp.LsEntry)files.get(0);
                this.pollFile(file);
            }
            this.lastPollTime = System.currentTimeMillis();
        }
        catch (Exception e) {
            if (this.isStopping() || this.isStopped()) {
                this.log.warn((Object)("Consumer is stopping. Ignoring caught exception: " + e.getClass().getCanonicalName() + " message: " + e.getMessage()));
            }
            this.log.warn((Object)("Exception occured during polling: " + e.getClass().getCanonicalName() + " message: " + e.getMessage()));
            this.disconnect();
            throw e;
        }
    }

    protected void pollDirectory(String dir) throws Exception {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Polling directory: " + dir));
        }
        String currentDir = this.channel.pwd();
        this.channel.cd(dir);
        Vector files = this.channel.ls(".");
        for (int i = 0; i < files.size(); ++i) {
            ChannelSftp.LsEntry sftpFile = (ChannelSftp.LsEntry)files.get(i);
            if (sftpFile.getFilename().startsWith(".")) continue;
            if (sftpFile.getAttrs().isDir()) {
                if (!this.isRecursive()) continue;
                this.pollDirectory(this.getFullFileName(sftpFile));
                continue;
            }
            this.pollFile(sftpFile);
        }
        this.channel.cd(currentDir);
    }

    protected String getFullFileName(ChannelSftp.LsEntry sftpFile) throws IOException, SftpException {
        return this.channel.pwd() + "/" + sftpFile.getFilename();
    }

    private void pollFile(ChannelSftp.LsEntry sftpFile) throws Exception {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Polling file: " + sftpFile));
        }
        boolean timestampMatched = true;
        if (this.isTimestamp()) {
            long ts = (long)sftpFile.getAttrs().getMTime() * 1000L;
            boolean bl = timestampMatched = ts > this.lastPollTime;
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("The file is to old + " + sftpFile + ". lastPollTime=" + this.lastPollTime + " > fileTimestamp=" + ts));
            }
        }
        if (timestampMatched && this.isMatched(sftpFile)) {
            String fullFileName = this.getFullFileName(sftpFile);
            if (this.exclusiveReadLock) {
                this.acquireExclusiveReadLock(sftpFile);
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.channel.get(sftpFile.getFilename(), (OutputStream)byteArrayOutputStream);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Retrieved file: " + sftpFile.getFilename() + " from: " + this.remoteServer()));
            }
            Object exchange = this.endpoint.createExchange(this.getFullFileName(sftpFile), sftpFile.getFilename(), sftpFile.getAttrs().getSize(), byteArrayOutputStream);
            if (this.isSetNames()) {
                String ftpBasePath = this.endpoint.getConfiguration().getFile();
                String relativePath = fullFileName.substring(ftpBasePath.length() + 1);
                relativePath = relativePath.replaceFirst("/", "");
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Setting exchange filename to " + relativePath));
                }
                exchange.getIn().setHeader("org.apache.camel.file.name", (Object)relativePath);
            }
            if (this.deleteFile) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Deleteing file: " + sftpFile.getFilename() + " from: " + this.remoteServer()));
                }
                this.deleteFile(sftpFile.getFilename());
            } else if (this.isMoveFile()) {
                String directory;
                int lastPathIndex;
                boolean deleted;
                String fromName = sftpFile.getFilename();
                String toName = this.getMoveFileName(fromName, (Exchange)exchange);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Moving file: " + fromName + " to: " + toName));
                }
                if (!(deleted = this.deleteFile(toName)) && (lastPathIndex = toName.lastIndexOf(47)) != -1 && !SftpUtils.buildDirectory(this.channel, directory = toName.substring(0, lastPathIndex))) {
                    this.log.warn((Object)("Can not build directory: " + directory + " (maybe because of denied permissions)"));
                }
                try {
                    this.channel.rename(fromName, toName);
                }
                catch (SftpException e) {
                    this.log.warn((Object)("Can not move file: " + fromName + " to: " + toName));
                }
            }
            this.getProcessor().process(exchange);
        }
    }

    private boolean deleteFile(String filename) {
        try {
            this.channel.rm(filename);
            return true;
        }
        catch (SftpException e) {
            this.log.warn((Object)("Could not delete file: " + filename + " from: " + this.remoteServer()));
            return false;
        }
    }

    protected void acquireExclusiveReadLock(ChannelSftp.LsEntry sftpFile) throws SftpException {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Waiting for exclusive read lock to file: " + sftpFile));
        }
        String originalName = sftpFile.getFilename();
        String newName = originalName + ".camelExclusiveReadLock";
        boolean exclusive = false;
        while (!exclusive) {
            try {
                this.channel.rename(originalName, newName);
                exclusive = true;
            }
            catch (SftpException e) {
                // empty catch block
            }
            if (exclusive) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Acquired exclusive read lock to file: " + originalName));
                }
                this.channel.rename(newName, originalName);
                continue;
            }
            this.log.trace((Object)"Exclusive read lock not granted. Sleeping for 1000 millis");
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {}
        }
    }

    @Override
    protected String getFileName(Object file) {
        ChannelSftp.LsEntry sftpFile = (ChannelSftp.LsEntry)file;
        return sftpFile.getFilename();
    }
}

