/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.camel.Processor;
import org.apache.camel.component.file.remote.RemoteFileConsumer;
import org.apache.camel.component.file.remote.RemoteFileExchange;
import org.apache.camel.component.file.remote.SftpEndpoint;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SftpConsumer
extends RemoteFileConsumer<RemoteFileExchange> {
    private static final transient Log LOG = LogFactory.getLog(SftpConsumer.class);
    private final SftpEndpoint endpoint;
    private boolean recursive = true;
    private String regexPattern = "";
    private long lastPollTime;
    private ChannelSftp channel;
    private Session session;
    private boolean setNames;

    public SftpConsumer(SftpEndpoint endpoint, Processor processor, Session session) {
        super(endpoint, processor);
        this.endpoint = endpoint;
        this.session = session;
    }

    public SftpConsumer(SftpEndpoint endpoint, Processor processor, Session session, ScheduledExecutorService executor) {
        super(endpoint, processor, executor);
        this.endpoint = endpoint;
        this.session = session;
    }

    protected void connectIfNecessary() throws JSchException {
        if (this.channel == null || !this.channel.isConnected()) {
            if (this.session == null || !this.session.isConnected()) {
                LOG.info((Object)"Session isn't connected, trying to recreate and connect...");
                this.session = this.endpoint.createSession();
                this.session.connect();
            }
            LOG.info((Object)"Channel isn't connected, trying to recreate and connect...");
            this.channel = this.endpoint.createChannelSftp(this.session);
            this.channel.connect();
            LOG.info((Object)("Connected to " + this.endpoint.getConfiguration().toString()));
        }
    }

    protected void disconnect() throws JSchException {
        if (this.session != null) {
            LOG.info((Object)"Session is being explicitly disconnected");
            this.session.disconnect();
        }
        if (this.channel != null) {
            LOG.info((Object)"Channel is being explicitly disconnected");
            this.channel.disconnect();
        }
    }

    protected void poll() throws Exception {
        this.connectIfNecessary();
        try {
            String fileName = this.endpoint.getConfiguration().getFile();
            if (this.endpoint.getConfiguration().isDirectory()) {
                this.pollDirectory(fileName);
            } else {
                this.channel.cd(fileName.substring(0, fileName.lastIndexOf(47)));
                ChannelSftp.LsEntry file = (ChannelSftp.LsEntry)this.channel.ls(fileName.substring(fileName.lastIndexOf(47) + 1)).get(0);
                this.pollFile(file);
            }
            this.lastPollTime = System.currentTimeMillis();
        }
        catch (JSchException e) {
            LOG.warn((Object)("Disconnecting due to exception: " + e.toString()));
            this.disconnect();
            throw e;
        }
        catch (SftpException e) {
            LOG.warn((Object)("Caught SftpException:" + e.toString()));
            LOG.warn((Object)"Doing nothing for now, need to determine an appropriate action");
            throw e;
        }
    }

    protected void pollDirectory(String dir) throws Exception {
        this.channel.cd(dir);
        for (ChannelSftp.LsEntry sftpFile : this.channel.ls(".").toArray(new ChannelSftp.LsEntry[0])) {
            if (sftpFile.getFilename().startsWith(".")) continue;
            if (sftpFile.getAttrs().isDir()) {
                if (!this.isRecursive()) continue;
                this.pollDirectory(this.getFullFileName(sftpFile));
                continue;
            }
            this.pollFile(sftpFile);
        }
    }

    protected String getFullFileName(ChannelSftp.LsEntry sftpFile) throws IOException, SftpException {
        return this.channel.pwd() + "/" + sftpFile.getFilename();
    }

    private void pollFile(ChannelSftp.LsEntry sftpFile) throws Exception {
        if ((long)sftpFile.getAttrs().getMTime() * 1000L > this.lastPollTime && this.isMatched(sftpFile)) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.channel.get(sftpFile.getFilename(), (OutputStream)byteArrayOutputStream);
            Object exchange = this.endpoint.createExchange(this.getFullFileName(sftpFile), byteArrayOutputStream);
            if (this.isSetNames()) {
                String relativePath = this.getFullFileName(sftpFile).substring(this.endpoint.getConfiguration().getFile().length());
                if (relativePath.startsWith("/")) {
                    relativePath = relativePath.substring(1);
                }
                exchange.getIn().setHeader("org.apache.camel.file.name", (Object)relativePath);
            }
            this.getProcessor().process(exchange);
        }
    }

    protected boolean isMatched(ChannelSftp.LsEntry sftpFile) {
        boolean result = true;
        if (this.regexPattern != null && this.regexPattern.length() > 0) {
            result = sftpFile.getFilename().matches(this.getRegexPattern());
        }
        return result;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public long getLastPollTime() {
        return this.lastPollTime;
    }

    public void setLastPollTime(long lastPollTime) {
        this.lastPollTime = lastPollTime;
    }

    public String getRegexPattern() {
        return this.regexPattern;
    }

    public void setRegexPattern(String regexPattern) {
        this.regexPattern = regexPattern;
    }

    public boolean isSetNames() {
        return this.setNames;
    }

    public void setSetNames(boolean setNames) {
        this.setNames = setNames;
    }
}

