/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import java.io.IOException;
import java.io.InputStream;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.file.remote.FtpEndpoint;
import org.apache.camel.component.file.remote.RemoteFileConfiguration;
import org.apache.camel.component.file.remote.RemoteFileExchange;
import org.apache.camel.component.file.remote.RemoteFileProducer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPConnectionClosedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FtpProducer
extends RemoteFileProducer<RemoteFileExchange> {
    private static final transient Log LOG = LogFactory.getLog(FtpProducer.class);
    private FtpEndpoint endpoint;
    private FTPClient client;

    public FtpProducer(FtpEndpoint endpoint, FTPClient client) {
        super(endpoint);
        this.endpoint = endpoint;
        this.client = client;
    }

    public void process(Exchange exchange) throws Exception {
        this.connectIfNecessary();
        try {
            this.process((RemoteFileExchange)this.endpoint.createExchange(exchange));
        }
        catch (FTPConnectionClosedException e) {
            LOG.warn((Object)("Disconnecting due to exception: " + e.toString()));
            this.disconnect();
            throw e;
        }
        catch (RuntimeCamelException e) {
            LOG.warn((Object)("Caught RuntimeCamelException: " + e.toString()));
            LOG.warn((Object)"Hoping an explicit disconnect/reconnect will solve the problem");
            this.disconnect();
            throw e;
        }
    }

    @Override
    protected void connectIfNecessary() throws IOException {
        if (!this.client.isConnected()) {
            LOG.warn((Object)"FtpProducer's client isn't connected, trying to reconnect...");
            this.endpoint.connect(this.client);
            LOG.info((Object)("Connected to " + this.endpoint.getConfiguration()));
        }
    }

    @Override
    public void disconnect() throws IOException {
        LOG.info((Object)"FtpProducer's client is being explicitly disconnected");
        this.endpoint.disconnect(this.client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(RemoteFileExchange exchange) throws Exception {
        InputStream payload = (InputStream)exchange.getIn().getBody(InputStream.class);
        try {
            boolean success;
            String directory;
            String fileName = this.createFileName(exchange.getIn(), this.endpoint.getConfiguration());
            int lastPathIndex = fileName.lastIndexOf(47);
            if (lastPathIndex != -1 && !FtpProducer.buildDirectory(this.client, directory = fileName.substring(0, lastPathIndex))) {
                LOG.warn((Object)("Couldn't build directory: " + directory + " (either permissions deny it, or it already exists)"));
            }
            if (!(success = this.client.storeFile(fileName, payload))) {
                throw new RuntimeCamelException("Error sending file: " + fileName);
            }
            RemoteFileConfiguration config = this.endpoint.getConfiguration();
            LOG.info((Object)("Sent: " + fileName + " to " + config.toString().substring(0, config.toString().indexOf(config.getFile()))));
        }
        finally {
            if (payload != null) {
                payload.close();
            }
        }
    }

    protected void doStart() throws Exception {
        LOG.info((Object)"Starting");
        try {
            this.connectIfNecessary();
        }
        catch (IOException e) {
            LOG.warn((Object)("Couldn't connect to " + this.endpoint.getConfiguration()));
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        LOG.info((Object)"Stopping");
        this.disconnect();
        super.doStop();
    }

    protected static boolean buildDirectory(FTPClient ftpClient, String dirName) throws IOException {
        String[] dirs;
        boolean atLeastOneSuccess = false;
        StringBuilder sb = new StringBuilder(dirName.length());
        for (String dir : dirs = dirName.split("\\/")) {
            sb.append(dir).append('/');
            String directory = sb.toString();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Trying to build directory: " + directory));
            }
            boolean success = ftpClient.makeDirectory(directory);
            if (atLeastOneSuccess || !success) continue;
            atLeastOneSuccess = true;
        }
        return atLeastOneSuccess;
    }
}

