/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.file.remote.FtpEndpoint;
import org.apache.camel.component.file.remote.RemoteFileConsumer;
import org.apache.camel.component.file.remote.RemoteFileExchange;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPConnectionClosedException;
import org.apache.commons.net.ftp.FTPFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FtpConsumer
extends RemoteFileConsumer<RemoteFileExchange> {
    private static final transient Log LOG = LogFactory.getLog(FtpConsumer.class);
    private final FtpEndpoint endpoint;
    private boolean recursive = true;
    private String regexPattern = "";
    private long lastPollTime;
    private FTPClient client;
    private boolean setNames;

    public FtpConsumer(FtpEndpoint endpoint, Processor processor, FTPClient client) {
        super(endpoint, processor);
        this.endpoint = endpoint;
        this.client = client;
    }

    public FtpConsumer(FtpEndpoint endpoint, Processor processor, FTPClient client, ScheduledExecutorService executor) {
        super(endpoint, processor, executor);
        this.endpoint = endpoint;
        this.client = client;
    }

    protected void connectIfNecessary() throws IOException {
        if (!this.client.isConnected()) {
            LOG.warn((Object)"FtpConsumer's client isn't connected, trying to reconnect...");
            this.endpoint.connect(this.client);
            LOG.info((Object)("Connected to " + this.endpoint.getConfiguration()));
        }
    }

    protected void disconnect() throws IOException {
        LOG.info((Object)"FtpConsumer's client is being explicitly disconnected");
        this.endpoint.disconnect(this.client);
    }

    protected void poll() throws Exception {
        this.connectIfNecessary();
        try {
            String fileName = this.endpoint.getConfiguration().getFile();
            if (this.endpoint.getConfiguration().isDirectory()) {
                this.pollDirectory(fileName);
            } else {
                this.client.changeWorkingDirectory(fileName.substring(0, fileName.lastIndexOf(47)));
                FTPFile[] files = this.client.listFiles(fileName.substring(fileName.lastIndexOf(47) + 1));
                this.pollFile(files[0]);
            }
            this.lastPollTime = System.currentTimeMillis();
        }
        catch (FTPConnectionClosedException e) {
            LOG.warn((Object)("Disconnecting due to exception: " + e.toString()));
            this.disconnect();
            throw e;
        }
        catch (RuntimeCamelException e) {
            LOG.warn((Object)("Caught RuntimeCamelException: " + e.toString()));
            LOG.warn((Object)"Hoping an explicit disconnect/reconnect will solve the problem");
            this.disconnect();
            throw e;
        }
    }

    protected void pollDirectory(String dir) throws Exception {
        this.client.changeWorkingDirectory(dir);
        for (FTPFile ftpFile : this.client.listFiles()) {
            if (ftpFile.isFile()) {
                this.pollFile(ftpFile);
                continue;
            }
            if (ftpFile.isDirectory()) {
                if (!this.isRecursive()) continue;
                this.pollDirectory(this.getFullFileName(ftpFile));
                continue;
            }
            LOG.warn((Object)("Unsupported type of FTPFile: " + ftpFile + " not a file or directory"));
        }
    }

    protected String getFullFileName(FTPFile ftpFile) throws IOException {
        return this.client.printWorkingDirectory() + "/" + ftpFile.getName();
    }

    private void pollFile(FTPFile ftpFile) throws Exception {
        if (ftpFile.getTimestamp().getTimeInMillis() > this.lastPollTime && this.isMatched(ftpFile)) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.client.retrieveFile(ftpFile.getName(), (OutputStream)byteArrayOutputStream);
            Object exchange = this.endpoint.createExchange(this.getFullFileName(ftpFile), byteArrayOutputStream);
            if (this.isSetNames()) {
                String relativePath = this.getFullFileName(ftpFile).substring(this.endpoint.getConfiguration().getFile().length());
                if (relativePath.startsWith("/")) {
                    relativePath = relativePath.substring(1);
                }
                exchange.getIn().setHeader("org.apache.camel.file.name", (Object)relativePath);
            }
            this.getProcessor().process(exchange);
        }
    }

    protected boolean isMatched(FTPFile file) {
        boolean result = true;
        if (this.regexPattern != null && this.regexPattern.length() > 0) {
            result = file.getName().matches(this.getRegexPattern());
        }
        return result;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public long getLastPollTime() {
        return this.lastPollTime;
    }

    public void setLastPollTime(long lastPollTime) {
        this.lastPollTime = lastPollTime;
    }

    public String getRegexPattern() {
        return this.regexPattern;
    }

    public void setRegexPattern(String regexPattern) {
        this.regexPattern = regexPattern;
    }

    public boolean isSetNames() {
        return this.setNames;
    }

    public void setSetNames(boolean setNames) {
        this.setNames = setNames;
    }
}

