/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.SftpException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.file.remote.RemoteFileExchange;
import org.apache.camel.component.file.remote.RemoteFileProducer;
import org.apache.camel.component.file.remote.SftpEndpoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SftpProducer
extends RemoteFileProducer<RemoteFileExchange> {
    SftpEndpoint endpoint;
    private final ChannelSftp channel;

    public SftpProducer(SftpEndpoint endpoint, ChannelSftp channelSftp) {
        super(endpoint);
        this.endpoint = endpoint;
        this.channel = channelSftp;
    }

    public void process(Exchange exchange) throws Exception {
        this.process((RemoteFileExchange)this.endpoint.createExchange(exchange));
    }

    public void process(RemoteFileExchange exchange) throws Exception {
        InputStream payload = (InputStream)exchange.getIn().getBody(InputStream.class);
        String endpointFile = this.endpoint.getConfiguration().getFile();
        this.channel.cd(endpointFile);
        String fileName = this.createFileName(exchange.getIn(), this.endpoint.getConfiguration());
        SftpProducer.buildDirectory(this.channel, fileName.substring(0, fileName.lastIndexOf(47)));
        try {
            this.channel.put(payload, fileName);
        }
        catch (SftpException e) {
            throw new RuntimeCamelException("error sending file", (Throwable)e);
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
    }

    protected void doStop() throws Exception {
        this.channel.disconnect();
        super.doStop();
    }

    protected static boolean buildDirectory(ChannelSftp sftpClient, String dirName) throws IOException {
        String[] dirs;
        boolean atLeastOneSuccess = false;
        StringBuilder sb = new StringBuilder(dirName.length());
        for (String dir : dirs = dirName.split("\\/")) {
            sb.append('/').append(dir);
            try {
                sftpClient.mkdir(sb.toString());
                if (atLeastOneSuccess) continue;
                atLeastOneSuccess = true;
            }
            catch (SftpException e) {
                // empty catch block
            }
        }
        return atLeastOneSuccess;
    }
}

