/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import java.net.URI;
import org.apache.camel.RuntimeCamelException;

public class RemoteFileConfiguration
implements Cloneable {
    private String protocol;
    private String username;
    private String host;
    private int port;
    private String password;
    private String file;
    private boolean binary;
    private boolean directory = true;

    public RemoteFileConfiguration() {
    }

    public RemoteFileConfiguration(URI uri) {
        this.configure(uri);
    }

    public RemoteFileConfiguration copy() {
        try {
            return (RemoteFileConfiguration)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    public String toString() {
        return this.protocol + ":\\" + this.username + "@" + this.host + ":" + this.port + "/" + this.directory;
    }

    public void configure(URI uri) {
        this.setProtocol(uri.getScheme());
        this.setDefaultPort();
        this.setUsername(uri.getUserInfo());
        this.setHost(uri.getHost());
        this.setPort(uri.getPort());
        this.setFile(uri.getPath());
    }

    protected void setDefaultPort() {
        if ("ftp".equalsIgnoreCase(this.protocol)) {
            this.setPort(21);
        } else if ("sftp".equalsIgnoreCase(this.protocol)) {
            this.setPort(22);
        }
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        if (port != -1) {
            this.port = port;
        }
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public boolean isBinary() {
        return this.binary;
    }

    public void setBinary(boolean binary) {
        this.binary = binary;
    }

    public boolean isDirectory() {
        return this.directory;
    }

    public void setDirectory(boolean directory) {
        this.directory = directory;
    }

    public String dump() {
        return "RemoteFileConfiguration{protocol='" + this.protocol + '\'' + ", username='" + this.username + '\'' + ", host='" + this.host + '\'' + ", port=" + this.port + ", password='" + this.password + '\'' + ", file='" + this.file + '\'' + ", binary=" + this.binary + ", directory=" + this.directory + '}';
    }
}

