/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.camel.Processor;
import org.apache.camel.component.file.remote.FtpEndpoint;
import org.apache.camel.component.file.remote.RemoteFileConsumer;
import org.apache.camel.component.file.remote.RemoteFileExchange;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FtpConsumer
extends RemoteFileConsumer<RemoteFileExchange> {
    private boolean recursive = true;
    private String regexPattern = "";
    private long lastPollTime;
    private final FtpEndpoint endpoint;
    private FTPClient client;

    public FtpConsumer(FtpEndpoint endpoint, Processor processor, FTPClient client) {
        super(endpoint, processor);
        this.endpoint = endpoint;
        this.client = client;
    }

    public FtpConsumer(FtpEndpoint endpoint, Processor processor, FTPClient client, ScheduledExecutorService executor) {
        super(endpoint, processor, executor);
        this.endpoint = endpoint;
        this.client = client;
    }

    protected void poll() throws Exception {
        String fileName = this.endpoint.getConfiguration().getFile();
        if (this.endpoint.getConfiguration().isDirectory()) {
            this.pollDirectory(fileName);
        } else {
            this.client.changeWorkingDirectory(fileName.substring(0, fileName.lastIndexOf(47)));
            FTPFile[] files = this.client.listFiles(fileName.substring(fileName.lastIndexOf(47) + 1));
            this.pollFile(files[0]);
        }
        this.lastPollTime = System.currentTimeMillis();
    }

    protected void pollDirectory(String dir) throws Exception {
        this.client.changeWorkingDirectory(dir);
        for (FTPFile ftpFile : this.client.listFiles()) {
            if (ftpFile.isFile()) {
                this.pollFile(ftpFile);
                continue;
            }
            if (ftpFile.isDirectory()) {
                if (!this.isRecursive()) continue;
                this.pollDirectory(this.getFullFileName(ftpFile));
                continue;
            }
            throw new RuntimeException("");
        }
    }

    protected String getFullFileName(FTPFile ftpFile) throws IOException {
        return this.client.printWorkingDirectory() + "/" + ftpFile.getName();
    }

    private void pollFile(FTPFile ftpFile) throws Exception {
        if (ftpFile.getTimestamp().getTimeInMillis() > this.lastPollTime && this.isMatched(ftpFile)) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.client.retrieveFile(ftpFile.getName(), (OutputStream)byteArrayOutputStream);
            this.getProcessor().process(this.endpoint.createExchange(this.getFullFileName(ftpFile), byteArrayOutputStream));
        }
    }

    protected boolean isMatched(FTPFile file) {
        boolean result = true;
        if (this.regexPattern != null && this.regexPattern.length() > 0) {
            result = file.getName().matches(this.getRegexPattern());
        }
        return result;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public long getLastPollTime() {
        return this.lastPollTime;
    }

    public void setLastPollTime(long lastPollTime) {
        this.lastPollTime = lastPollTime;
    }

    public String getRegexPattern() {
        return this.regexPattern;
    }

    public void setRegexPattern(String regexPattern) {
        this.regexPattern = regexPattern;
    }
}

