/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import com.jcraft.jsch.ChannelSftp;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.camel.Processor;
import org.apache.camel.component.file.remote.RemoteFileConsumer;
import org.apache.camel.component.file.remote.RemoteFileExchange;
import org.apache.camel.component.file.remote.SftpEndpoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SftpConsumer
extends RemoteFileConsumer<RemoteFileExchange> {
    private boolean recursive = true;
    private String regexPattern = "";
    private long lastPollTime = 0L;
    private final SftpEndpoint endpoint;
    private ChannelSftp channel;

    public SftpConsumer(SftpEndpoint endpoint, Processor processor, ChannelSftp channel) {
        super(endpoint, processor);
        this.endpoint = endpoint;
        this.channel = channel;
    }

    public SftpConsumer(SftpEndpoint endpoint, Processor processor, ChannelSftp channel, ScheduledExecutorService executor) {
        super(endpoint, processor, executor);
        this.endpoint = endpoint;
        this.channel = channel;
    }

    protected void poll() throws Exception {
        String fileName = this.endpoint.getConfiguration().getFile();
        if (this.endpoint.getConfiguration().isDirectory()) {
            this.pollDirectory(fileName);
        } else {
            this.channel.cd(fileName.substring(0, fileName.lastIndexOf(47)));
            ChannelSftp.LsEntry file = (ChannelSftp.LsEntry)this.channel.ls(fileName.substring(fileName.lastIndexOf(47) + 1)).get(0);
            this.pollFile(file);
        }
        this.lastPollTime = System.currentTimeMillis();
    }

    protected void pollDirectory(String dir) throws Exception {
        this.channel.cd(dir);
        for (ChannelSftp.LsEntry sftpFile : this.channel.ls(".").toArray(new ChannelSftp.LsEntry[0])) {
            if (sftpFile.getFilename().startsWith(".")) continue;
            if (sftpFile.getAttrs().isDir()) {
                if (!this.isRecursive()) continue;
                this.pollDirectory(this.getFullFileName(sftpFile));
                continue;
            }
            this.pollFile(sftpFile);
        }
    }

    protected String getFullFileName(ChannelSftp.LsEntry sftpFile) throws IOException {
        return this.channel.pwd() + "/" + sftpFile.getFilename();
    }

    private void pollFile(ChannelSftp.LsEntry sftpFile) throws Exception {
        if ((long)(sftpFile.getAttrs().getMTime() * 1000) > this.lastPollTime && this.isMatched(sftpFile)) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.channel.get(sftpFile.getFilename(), (OutputStream)byteArrayOutputStream);
            this.getProcessor().process(this.endpoint.createExchange(this.getFullFileName(sftpFile), byteArrayOutputStream));
        }
    }

    protected boolean isMatched(ChannelSftp.LsEntry sftpFile) {
        boolean result = true;
        if (this.regexPattern != null && this.regexPattern.length() > 0) {
            result = sftpFile.getFilename().matches(this.getRegexPattern());
        }
        return result;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public long getLastPollTime() {
        return this.lastPollTime;
    }

    public void setLastPollTime(long lastPollTime) {
        this.lastPollTime = lastPollTime;
    }

    public String getRegexPattern() {
        return this.regexPattern;
    }

    public void setRegexPattern(String regexPattern) {
        this.regexPattern = regexPattern;
    }
}

