/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.fory;

import java.io.InputStream;
import java.io.OutputStream;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Dataformat;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.fory.BaseFory;
import org.apache.fory.Fory;
import org.apache.fory.config.ForyBuilder;
import org.apache.fory.config.Language;
import org.apache.fory.io.ForyInputStream;

@Dataformat(value="fory")
@Metadata(firstVersion="4.9.0", title="Fory")
public class ForyDataFormat
extends ServiceSupport
implements DataFormat,
DataFormatName,
CamelContextAware {
    private CamelContext camelContext;
    private Class<?> unmarshalType;
    private String unmarshalTypeName;
    private boolean requireClassRegistration = true;
    private boolean threadSafe = true;
    private boolean allowAutoWiredFury = true;
    private BaseFory fory;

    public ForyDataFormat() {
        this(Object.class);
    }

    public ForyDataFormat(Class<?> unmarshalType) {
        this.unmarshalType = unmarshalType;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public String getDataFormatName() {
        return "fory";
    }

    public void marshal(Exchange exchange, Object graph, OutputStream stream) throws Exception {
        this.fory.serialize(stream, graph);
    }

    public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
        return this.fory.deserialize(new ForyInputStream(stream));
    }

    protected void doInit() throws Exception {
        if (this.unmarshalTypeName != null && (this.unmarshalType == null || this.unmarshalType == Object.class)) {
            this.unmarshalType = this.camelContext.getClassResolver().resolveClass(this.unmarshalTypeName);
        }
        if (this.fory == null && this.isAllowAutoWiredFury()) {
            this.fory = (BaseFory)this.getCamelContext().getRegistry().findSingleByType(BaseFory.class);
        }
        if (this.fory == null) {
            ForyBuilder builder = Fory.builder().withLanguage(Language.JAVA);
            builder.requireClassRegistration(this.requireClassRegistration);
            Object object = this.fory = this.threadSafe ? builder.buildThreadSafeFory() : builder.build();
        }
        if (this.unmarshalType != null) {
            this.fory.register(this.unmarshalType);
        }
    }

    public BaseFory getFory() {
        return this.fory;
    }

    public void setFory(BaseFory fory) {
        this.fory = fory;
    }

    public Class<?> getUnmarshalType() {
        return this.unmarshalType;
    }

    public void setUnmarshalType(Class<?> unmarshalType) {
        this.unmarshalType = unmarshalType;
    }

    public String getUnmarshalTypeName() {
        return this.unmarshalTypeName;
    }

    public void setUnmarshalTypeName(String unmarshalTypeName) {
        this.unmarshalTypeName = unmarshalTypeName;
    }

    public boolean isRequireClassRegistration() {
        return this.requireClassRegistration;
    }

    public void setRequireClassRegistration(boolean requireClassRegistration) {
        this.requireClassRegistration = requireClassRegistration;
    }

    public boolean isThreadSafe() {
        return this.threadSafe;
    }

    public void setThreadSafe(boolean threadSafe) {
        this.threadSafe = threadSafe;
    }

    public boolean isAllowAutoWiredFury() {
        return this.allowAutoWiredFury;
    }

    public void setAllowAutoWiredFury(boolean allowAutoWiredFury) {
        this.allowAutoWiredFury = allowAutoWiredFury;
    }
}

