/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.flatpack;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.AbstractList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Properties;
import java.util.function.DoubleSupplier;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import net.sf.flatpack.DataError;
import net.sf.flatpack.DataSet;
import net.sf.flatpack.Record;
import net.sf.flatpack.ordering.OrderBy;
import org.apache.camel.component.flatpack.FlatpackConverter;

public class DataSetList
extends AbstractList<Map<String, Object>>
implements DataSet {
    private final DataSet dataSet;

    public DataSetList(DataSet dataSet) {
        this.dataSet = dataSet;
    }

    @Override
    public Map<String, Object> get(int index) {
        this.dataSet.absolute(index);
        return FlatpackConverter.toMap((Record)this.dataSet);
    }

    @Override
    public int size() {
        return this.dataSet.getRowCount();
    }

    @Override
    public Iterator<Map<String, Object>> iterator() {
        this.dataSet.goTop();
        return new Iterator<Map<String, Object>>(){
            Optional<Record> nextData = Optional.empty();

            @Override
            public boolean hasNext() {
                if (this.nextData.isPresent()) {
                    return true;
                }
                this.nextData = DataSetList.this.next() ? DataSetList.this.dataSet.getRecord() : Optional.empty();
                return this.nextData.isPresent();
            }

            @Override
            public Map<String, Object> next() {
                if (this.nextData.isPresent() || this.hasNext()) {
                    Record line = this.nextData.orElse(null);
                    this.nextData = Optional.empty();
                    return FlatpackConverter.toMap(line);
                }
                throw new NoSuchElementException();
            }
        };
    }

    public void goTop() {
        this.dataSet.goTop();
    }

    public void goBottom() {
        this.dataSet.goBottom();
    }

    public boolean previous() {
        return this.dataSet.previous();
    }

    public List<DataError> getErrors() {
        return this.dataSet.getErrors();
    }

    public void remove() {
        this.dataSet.remove();
    }

    public int getIndex() {
        return this.dataSet.getIndex();
    }

    public int getRowCount() {
        return this.dataSet.getRowCount();
    }

    public int getErrorCount() {
        return this.dataSet.getErrorCount();
    }

    public boolean isAnError(int lineNo) {
        return this.dataSet.isAnError(lineNo);
    }

    public void orderRows(OrderBy ob) {
        this.dataSet.orderRows(ob);
    }

    public void setLowerCase() {
        this.dataSet.setLowerCase();
    }

    public void setUpperCase() {
        this.dataSet.setUpperCase();
    }

    public void absolute(int localPointer) {
        this.dataSet.absolute(localPointer);
    }

    public void setStrictNumericParse(boolean strictNumericParse) {
        this.dataSet.setStrictNumericParse(strictNumericParse);
    }

    public void setPZConvertProps(Properties props) {
        this.dataSet.setPZConvertProps(props);
    }

    public void setValue(String column, String value) {
        this.dataSet.setValue(column, value);
    }

    public void clearRows() {
        this.dataSet.clearRows();
    }

    public void clearErrors() {
        this.dataSet.clearErrors();
    }

    public void clearAll() {
        this.dataSet.clearAll();
    }

    public String getString(String column) {
        return this.dataSet.getString(column);
    }

    public double getDouble(String column) {
        return this.dataSet.getDouble(column);
    }

    public BigDecimal getBigDecimal(String column) {
        return this.dataSet.getBigDecimal(column);
    }

    public int getInt(String column) {
        return this.dataSet.getInt(column);
    }

    public long getLong(String column) {
        return this.dataSet.getLong(column);
    }

    public Date getDate(String column) throws ParseException {
        return this.dataSet.getDate(column);
    }

    public Date getDate(String column, SimpleDateFormat sdf) throws ParseException {
        return this.dataSet.getDate(column, sdf);
    }

    public Object getObject(String column, Class<?> classToConvertTo) {
        return this.dataSet.getObject(column, classToConvertTo);
    }

    public String[] getColumns() {
        return this.dataSet.getColumns();
    }

    public String[] getColumns(String recordID) {
        return this.dataSet.getColumns(recordID);
    }

    public int getRowNo() {
        return this.dataSet.getRowNo();
    }

    public boolean isRecordID(String recordID) {
        return this.dataSet.isRecordID(recordID);
    }

    public boolean contains(String column) {
        return this.dataSet.contains(column);
    }

    public boolean isRowEmpty() {
        return this.dataSet.isRowEmpty();
    }

    public String getRawData() {
        return this.dataSet.getRawData();
    }

    public boolean next() {
        return this.dataSet.next();
    }

    public String getString(String column, Supplier<String> defaultSupplier) {
        return this.dataSet.getString(column, defaultSupplier);
    }

    public double getDouble(String column, DoubleSupplier defaultSupplier) {
        return this.dataSet.getDouble(column, defaultSupplier);
    }

    public BigDecimal getBigDecimal(String column, Supplier<BigDecimal> defaultSupplier) {
        return this.dataSet.getBigDecimal(column, defaultSupplier);
    }

    public int getInt(String column, IntSupplier defaultSupplier) {
        return this.dataSet.getInt(column, defaultSupplier);
    }

    public long getLong(String column, LongSupplier defaultSupplier) {
        return this.dataSet.getLong(column, defaultSupplier);
    }

    public Date getDate(String column, Supplier<Date> defaultSupplier) throws ParseException {
        return this.dataSet.getDate(column, defaultSupplier);
    }

    public Date getDate(String column, SimpleDateFormat sdf, Supplier<Date> defaultSupplier) throws ParseException {
        return this.dataSet.getDate(column, sdf, defaultSupplier);
    }

    public LocalDate getLocalDate(String column, Supplier<LocalDate> defaultSupplier) throws ParseException {
        return this.dataSet.getLocalDate(column, defaultSupplier);
    }

    public LocalDate getLocalDate(String column) throws ParseException {
        return this.dataSet.getLocalDate(column);
    }

    public LocalDate getLocalDate(String column, DateTimeFormatter formatter) throws ParseException {
        return this.dataSet.getLocalDate(column, formatter);
    }

    public LocalDate getLocalDate(String column, String dateFormat, Supplier<LocalDate> defaultSupplier) throws ParseException {
        return this.dataSet.getLocalDate(column, dateFormat, defaultSupplier);
    }

    public LocalDate getLocalDate(String column, String dateFormat) throws ParseException {
        return this.dataSet.getLocalDate(column, dateFormat);
    }

    public String getRecordID() {
        return this.dataSet.getRecordID();
    }

    public Optional<Record> getRecord() {
        return this.dataSet.getRecord();
    }
}

