/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.flatpack;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import net.sf.flatpack.Parser;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.component.flatpack.FixedLengthEndpoint;
import org.apache.camel.util.ExchangeHelper;
import org.springframework.core.io.Resource;

public class DelimitedEndpoint
extends FixedLengthEndpoint {
    private char delimiter = (char)44;
    private char textQualifier = (char)34;
    private boolean ignoreFirstRecord = true;

    public DelimitedEndpoint(String uri, Resource resource) {
        super(uri, resource);
    }

    public Parser createParser(Exchange exchange) throws InvalidPayloadException, IOException {
        Reader bodyReader = (Reader)ExchangeHelper.getMandatoryInBody((Exchange)exchange, Reader.class);
        Resource resource = this.getResource();
        if (resource == null) {
            return this.getParserFactory().newDelimitedParser(bodyReader, this.delimiter, this.textQualifier);
        }
        return this.getParserFactory().newDelimitedParser((Reader)new InputStreamReader(resource.getInputStream()), bodyReader, this.delimiter, this.textQualifier, this.ignoreFirstRecord);
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(char delimiter) {
        this.delimiter = delimiter;
    }

    public boolean isIgnoreFirstRecord() {
        return this.ignoreFirstRecord;
    }

    public void setIgnoreFirstRecord(boolean ignoreFirstRecord) {
        this.ignoreFirstRecord = ignoreFirstRecord;
    }

    public char getTextQualifier() {
        return this.textQualifier;
    }

    public void setTextQualifier(char textQualifier) {
        this.textQualifier = textQualifier;
    }
}

