/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.cluster;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.apache.camel.component.file.cluster.FileLockClusterService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FileLockClusterTaskExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileLockClusterTaskExecutor.class);
    private final FileLockClusterService service;

    FileLockClusterTaskExecutor(FileLockClusterService service) {
        Objects.requireNonNull(service, "FileLockClusterService cannot be null");
        this.service = service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T run(Supplier<T> task) throws ExecutionException, TimeoutException {
        Objects.requireNonNull(task, "Task cannot be null");
        int maxAttempts = this.service.getClusterDataTaskMaxAttempts();
        for (int attempt = 1; attempt <= maxAttempts; ++attempt) {
            LOGGER.debug("Running cluster task attempt {} of {}", (Object)attempt, (Object)maxAttempts);
            CompletableFuture<T> future = CompletableFuture.supplyAsync(task, this.service.getClusterDataTaskExecutor());
            try {
                T t = future.get(this.service.getClusterDataTaskTimeout(), this.service.getClusterDataTaskTimeoutUnit());
                return t;
            }
            catch (InterruptedException e) {
                LOGGER.trace("Cluster task interrupted on attempt {} of {}", (Object)attempt, (Object)maxAttempts);
                future.cancel(true);
                Thread.currentThread().interrupt();
                T t = null;
                return t;
            }
            catch (ExecutionException | TimeoutException e) {
                LOGGER.debug("Cluster task encountered an exception on attempt {} of {}", new Object[]{attempt, maxAttempts, e});
                future.cancel(true);
                if (attempt != maxAttempts) continue;
                LOGGER.debug("Cluster task retry limit ({}) reached", (Object)maxAttempts, (Object)e);
                throw e;
            }
            finally {
                LOGGER.debug("Cluster task attempt {} ended", (Object)attempt);
            }
        }
        return null;
    }
}

