/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.file.FileBinding;
import org.apache.camel.component.file.FileEndpoint;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileConsumer;
import org.apache.camel.component.file.GenericFileOperationFailedException;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.component.file.GenericFileProcessStrategy;
import org.apache.camel.component.file.consumer.DirectoryEntriesResumeAdapter;
import org.apache.camel.component.file.consumer.FileOffsetResumeAdapter;
import org.apache.camel.resume.ResumeAdapter;
import org.apache.camel.resume.ResumeAware;
import org.apache.camel.resume.ResumeStrategy;
import org.apache.camel.support.resume.Resumables;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileConsumer
extends GenericFileConsumer<File>
implements ResumeAware<ResumeStrategy> {
    private static final Logger LOG = LoggerFactory.getLogger(FileConsumer.class);
    private ResumeStrategy resumeStrategy;
    private String endpointPath;
    private Set<String> extendedAttributes;

    public FileConsumer(FileEndpoint endpoint, Processor processor, GenericFileOperations<File> operations, GenericFileProcessStrategy<File> processStrategy) {
        super(endpoint, processor, operations, processStrategy);
        this.endpointPath = endpoint.getConfiguration().getDirectory();
        if (endpoint.getExtendedAttributes() != null) {
            List<String> attributes = Arrays.asList(endpoint.getExtendedAttributes().split(","));
            this.extendedAttributes = new HashSet<String>(attributes);
        }
    }

    @Override
    protected Exchange createExchange(GenericFile<File> file) {
        Exchange exchange = this.createExchange(true);
        if (file != null) {
            file.bindToExchange(exchange, this.getEndpoint().isProbeContentType());
        }
        return exchange;
    }

    private boolean pollDirectory(File directory, List<GenericFile<File>> fileList, int depth) {
        File[] files;
        ++depth;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Polling directory: {}, absolute path: {}", (Object)directory.getPath(), (Object)directory.getAbsolutePath());
        }
        if ((files = this.listFiles(directory)) == null || files.length == 0) {
            return true;
        }
        if (this.getEndpoint().isPreSort()) {
            Arrays.sort(files, Comparator.comparing(File::getAbsoluteFile));
        }
        for (File file : files) {
            if (!this.canPollMoreFiles(fileList)) {
                return false;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Found file: {} [isAbsolute: {}, isDirectory: {}, isFile: {}, isHidden: {}]", new Object[]{file, file.isAbsolute(), file.isDirectory(), file.isFile(), file.isHidden()});
            }
            GenericFile<File> gf = FileConsumer.asGenericFile(this.endpointPath, file, this.getEndpoint().getCharset(), this.getEndpoint().isProbeContentType());
            if (this.resumeStrategy != null) {
                ResumeAdapter adapter = this.resumeStrategy.getAdapter();
                LOG.trace("Checking the resume adapter: {}", (Object)adapter);
                if (adapter instanceof FileOffsetResumeAdapter) {
                    LOG.trace("The resume adapter is for offsets: {}", (Object)adapter);
                    ((FileOffsetResumeAdapter)adapter).setResumePayload(gf);
                    adapter.resume();
                }
                if (adapter instanceof DirectoryEntriesResumeAdapter) {
                    LOG.trace("Running the resume process for file {}", (Object)file);
                    if (((DirectoryEntriesResumeAdapter)adapter).resume(file)) {
                        LOG.trace("Skipping file {} because it has been marked previously consumed", (Object)file);
                        continue;
                    }
                }
            }
            if (file.isDirectory()) {
                boolean canPollMore;
                if (!this.endpoint.isRecursive() || depth >= this.endpoint.getMaxDepth() || !this.isValidFile(gf, true, files) || (canPollMore = this.pollDirectory(file, fileList, depth))) continue;
                return false;
            }
            if (depth < this.endpoint.minDepth || !this.isValidFile(gf, false, files)) continue;
            LOG.trace("Adding valid file: {}", (Object)file);
            if (this.extendedAttributes != null) {
                Path path = file.toPath();
                HashMap<String, Object> allAttributes = new HashMap<String, Object>();
                for (String attribute : this.extendedAttributes) {
                    this.readAttributes(file, path, allAttributes, attribute);
                }
                gf.setExtendedAttributes(allAttributes);
            }
            fileList.add(gf);
        }
        return true;
    }

    @Override
    protected boolean pollDirectory(String fileName, List<GenericFile<File>> fileList, int depth) {
        LOG.trace("pollDirectory from fileName: {}", (Object)fileName);
        File directory = new File(fileName);
        if (!directory.exists() || !directory.isDirectory()) {
            LOG.debug("Cannot poll as directory does not exists or its not a directory: {}", (Object)directory);
            if (this.getEndpoint().isDirectoryMustExist()) {
                throw new GenericFileOperationFailedException("Directory does not exist: " + directory);
            }
            return true;
        }
        return this.pollDirectory(directory, fileList, depth);
    }

    private File[] listFiles(File directory) {
        File[] dirFiles = directory.listFiles();
        if (dirFiles == null || dirFiles.length == 0) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("No files found in directory: {}", (Object)directory.getPath());
            }
            return null;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Found {} in directory: {}", (Object)dirFiles.length, (Object)directory.getPath());
        }
        return dirFiles;
    }

    private void readAttributes(File file, Path path, Map<String, Object> allAttributes, String attribute) {
        block11: {
            try {
                String prefix = null;
                if (attribute.endsWith(":*")) {
                    prefix = attribute.substring(0, attribute.length() - 1);
                } else if (attribute.equals("*")) {
                    prefix = "basic:";
                }
                if (ObjectHelper.isNotEmpty((String)prefix)) {
                    Map<String, Object> attributes = Files.readAttributes(path, attribute, new LinkOption[0]);
                    if (attributes != null) {
                        for (Map.Entry<String, Object> entry : attributes.entrySet()) {
                            allAttributes.put(prefix + entry.getKey(), entry.getValue());
                        }
                    }
                } else if (!attribute.contains(":")) {
                    allAttributes.put("basic:" + attribute, Files.getAttribute(path, attribute, new LinkOption[0]));
                } else {
                    allAttributes.put(attribute, Files.getAttribute(path, attribute, new LinkOption[0]));
                }
            }
            catch (IOException e) {
                if (!LOG.isDebugEnabled()) break block11;
                LOG.debug("Unable to read attribute {} on file {}", new Object[]{attribute, file, e});
            }
        }
    }

    protected boolean isMatched(GenericFile<File> file, String doneFileName, File[] files) {
        String onlyName = FileUtil.stripPath((String)doneFileName);
        for (File f : files) {
            if (!f.getName().equals(onlyName)) continue;
            return true;
        }
        LOG.trace("Done file: {} does not exist", (Object)doneFileName);
        return false;
    }

    public static GenericFile<File> asGenericFile(String endpointPath, File file, String charset, boolean probeContentType) {
        File path;
        GenericFile<File> answer = new GenericFile<File>(probeContentType);
        answer.setBinding(new FileBinding());
        answer.setCharset(charset);
        answer.setEndpointPath(endpointPath);
        answer.setFile(file);
        answer.setFileNameOnly(file.getName());
        answer.setDirectory(file.isDirectory());
        answer.setAbsolute(FileUtil.isAbsolute((File)file));
        answer.setAbsoluteFilePath(file.getAbsolutePath());
        answer.setFileLengthSupplier(file::length);
        answer.setLastModifiedSupplier(file::lastModified);
        String endpointNormalizedSep = FileUtil.normalizePath((String)endpointPath) + File.separator;
        String p = file.getPath();
        if (p.startsWith(endpointNormalizedSep)) {
            p = p.substring(endpointNormalizedSep.length());
        }
        if ((path = new File(p)).getParent() != null) {
            answer.setRelativeFilePath(path.getParent() + File.separator + file.getName());
        } else {
            answer.setRelativeFilePath(path.getName());
        }
        answer.setFileName(answer.getRelativeFilePath());
        answer.setBody(file);
        return answer;
    }

    @Override
    protected void updateFileHeaders(GenericFile<File> file, Message message) {
        File upToDateFile = file.getFile();
        if (this.fileHasMoved(file)) {
            upToDateFile = new File(file.getAbsoluteFilePath());
        }
        long length = upToDateFile.length();
        long modified = upToDateFile.lastModified();
        file.setFileLength(length);
        file.setLastModified(modified);
        if (length >= 0L) {
            message.setHeader("CamelFileLength", (Object)length);
        }
        if (modified >= 0L) {
            message.setHeader("CamelFileLastModified", (Object)modified);
        }
        message.setHeader("CamelFileInitialOffset", (Object)Resumables.of((Object)upToDateFile, (Object)file.getLastOffsetValue()));
    }

    public FileEndpoint getEndpoint() {
        return (FileEndpoint)super.getEndpoint();
    }

    @Override
    protected boolean isMatchedHiddenFile(GenericFile<File> file, boolean isDirectory) {
        if (this.getEndpoint().isIncludeHiddenFiles()) {
            String name;
            return !isDirectory || !(name = file.getFileNameOnly()).startsWith(".");
        }
        return super.isMatchedHiddenFile(file, isDirectory);
    }

    private boolean fileHasMoved(GenericFile<File> file) {
        return !file.getFile().getAbsolutePath().equals(file.getAbsoluteFilePath());
    }

    @Override
    protected void doStart() throws Exception {
        if (this.resumeStrategy != null) {
            this.resumeStrategy.loadCache();
        }
        super.doStart();
    }

    public ResumeStrategy getResumeStrategy() {
        return this.resumeStrategy;
    }

    public void setResumeStrategy(ResumeStrategy resumeStrategy) {
        this.resumeStrategy = resumeStrategy;
    }

    public String adapterFactoryService() {
        return "file-adapter-factory";
    }
}

