/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.function.Supplier;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.FallbackConverter;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.util.IOHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Converter
public final class GenericFileConverter {
    static Supplier<Charset> defaultCharset = Charset::defaultCharset;
    private static final Logger LOG = LoggerFactory.getLogger(GenericFileConverter.class);

    private GenericFileConverter() {
    }

    @FallbackConverter
    public static Object convertTo(Class<?> type, Exchange exchange, Object value, TypeConverterRegistry registry) throws IOException, NoTypeConversionAvailableException {
        if (GenericFile.class.isAssignableFrom(value.getClass())) {
            GenericFile file = (GenericFile)value;
            Class<?> from = file.getBody().getClass();
            if (from.isAssignableFrom(type)) {
                return file.getBody();
            }
            TypeConverter tc = registry.lookup(type, from);
            if (tc != null) {
                InputStream is;
                BufferedReader reader;
                Object body = file.getBody();
                if (Reader.class.isAssignableFrom(type) && (reader = GenericFileConverter.genericFileToReader(file, exchange)) != null) {
                    return reader;
                }
                if (InputStream.class.isAssignableFrom(type) && (is = GenericFileConverter.genericFileToInputStream(file, exchange)) != null) {
                    return is;
                }
                if (body instanceof File && file.getCharset() != null) {
                    reader = GenericFileConverter.genericFileToReader(file, exchange);
                    TypeConverter readerTc = registry.lookup(type, Reader.class);
                    if (readerTc != null) {
                        return readerTc.convertTo(type, exchange, (Object)reader);
                    }
                }
                return tc.convertTo(type, exchange, body);
            }
        }
        return null;
    }

    @Converter
    public static InputStream genericFileToInputStream(GenericFile<?> file, Exchange exchange) throws IOException {
        File f;
        if (file.getFile() instanceof File && (f = (File)file.getFile()).exists()) {
            String charset = file.getCharset();
            if (charset != null) {
                LOG.debug("Read file {} with charset {}", (Object)f, (Object)file.getCharset());
            } else {
                LOG.debug("Read file {} (no charset)", (Object)f);
            }
            return GenericFileConverter.toInputStream(f, charset);
        }
        if (exchange != null) {
            file.getBinding().loadContent(exchange, file);
            return (InputStream)exchange.getContext().getTypeConverter().convertTo(InputStream.class, exchange, file.getBody());
        }
        return null;
    }

    @Converter
    public static String genericFileToString(GenericFile<?> file, Exchange exchange) throws IOException, NoTypeConversionAvailableException {
        BufferedReader reader = GenericFileConverter.genericFileToReader(file, exchange);
        if (reader != null) {
            return GenericFileConverter.toString(reader);
        }
        if (exchange != null) {
            file.getBinding().loadContent(exchange, file);
            return (String)exchange.getContext().getTypeConverter().convertTo(String.class, exchange, file.getBody());
        }
        return null;
    }

    @Converter
    public static Serializable genericFileToSerializable(GenericFile<?> file, Exchange exchange) throws IOException {
        byte[] data;
        InputStream is;
        if (exchange != null && (is = GenericFileConverter.genericFileToInputStream(file, exchange)) != null && (data = (byte[])exchange.getContext().getTypeConverter().convertTo(byte[].class, exchange, (Object)is)) != null) {
            return (Serializable)exchange.getContext().getTypeConverter().convertTo(Serializable.class, exchange, (Object)data);
        }
        return null;
    }

    private static BufferedReader genericFileToReader(GenericFile<?> file, Exchange exchange) throws IOException {
        if (file.getFile() instanceof File) {
            File f = (File)file.getFile();
            if (!f.exists()) {
                return null;
            }
            String charset = file.getCharset();
            if (charset != null) {
                LOG.debug("Read file {} with charset {}", (Object)f, (Object)file.getCharset());
                return GenericFileConverter.toReader(f, charset);
            }
            LOG.debug("Read file {} (no charset)", (Object)f);
            return GenericFileConverter.toReader(f, ExchangeHelper.getCharsetName((Exchange)exchange));
        }
        return null;
    }

    private static BufferedReader toReader(File file, String charset) throws IOException {
        FileInputStream in = new FileInputStream(file);
        return IOHelper.buffered((Reader)new EncodingFileReader(in, charset));
    }

    private static InputStream toInputStream(File file, String charset) throws IOException {
        if (charset != null) {
            return new EncodingInputStream(file, charset);
        }
        return GenericFileConverter.toInputStream(file);
    }

    private static InputStream toInputStream(File file) throws IOException {
        return IOHelper.buffered((InputStream)new FileInputStream(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String toString(BufferedReader reader) throws IOException {
        StringBuilder sb = new StringBuilder(1024);
        char[] buf = new char[1024];
        try {
            int len;
            while ((len = reader.read(buf)) != -1) {
                sb.append(buf, 0, len);
            }
        }
        finally {
            IOHelper.close((Closeable)reader, (String)"reader", (Logger)LOG);
        }
        return sb.toString();
    }

    public static class EncodingInputStream
    extends InputStream {
        private final File file;
        private final BufferedReader reader;
        private final Charset defaultStreamCharset;
        private ByteBuffer bufferBytes;
        private CharBuffer bufferedChars = CharBuffer.allocate(4096);

        public EncodingInputStream(File file, String charset) throws IOException {
            this.file = file;
            this.reader = GenericFileConverter.toReader(file, charset);
            this.defaultStreamCharset = defaultCharset.get();
        }

        @Override
        public int read() throws IOException {
            if (this.bufferBytes == null || this.bufferBytes.remaining() <= 0) {
                this.bufferedChars.clear();
                int len = this.reader.read(this.bufferedChars);
                this.bufferedChars.flip();
                if (len == -1) {
                    return -1;
                }
                this.bufferBytes = this.defaultStreamCharset.encode(this.bufferedChars);
            }
            return this.bufferBytes.get();
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }

        @Override
        public void reset() throws IOException {
            this.reader.reset();
        }

        public InputStream toOriginalInputStream() throws FileNotFoundException {
            return new FileInputStream(this.file);
        }
    }

    private static class EncodingFileReader
    extends InputStreamReader {
        private final FileInputStream in;

        EncodingFileReader(FileInputStream in, String charset) throws FileNotFoundException, UnsupportedEncodingException {
            super((InputStream)in, charset);
            this.in = in;
        }

        @Override
        public void close() throws IOException {
            try {
                super.close();
            }
            finally {
                this.in.close();
            }
        }
    }
}

