/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.fhir.api;

import ca.uhn.fhir.rest.client.api.IGenericClient;
import ca.uhn.fhir.rest.gclient.IClientExecutable;
import java.util.Map;
import org.apache.camel.component.fhir.api.ExtraParameters;
import org.hl7.fhir.instance.model.api.IBaseMetaType;
import org.hl7.fhir.instance.model.api.IIdType;

public class FhirMeta {
    private final IGenericClient client;

    public FhirMeta(IGenericClient client) {
        this.client = client;
    }

    public <T extends IBaseMetaType> T getFromServer(Class<T> metaType, Map<ExtraParameters, Object> extraParameters) {
        IClientExecutable clientExecutable = this.client.meta().get(metaType).fromServer();
        ExtraParameters.process(extraParameters, clientExecutable);
        return (T)((IBaseMetaType)clientExecutable.execute());
    }

    public <T extends IBaseMetaType> T getFromResource(Class<T> metaType, IIdType id, Map<ExtraParameters, Object> extraParameters) {
        IClientExecutable clientExecutable = this.client.meta().get(metaType).fromResource(id);
        ExtraParameters.process(extraParameters, clientExecutable);
        return (T)((IBaseMetaType)clientExecutable.execute());
    }

    public <T extends IBaseMetaType> T getFromType(Class<T> metaType, String resourceType, Map<ExtraParameters, Object> extraParameters) {
        IClientExecutable clientExecutable = this.client.meta().get(metaType).fromType(resourceType);
        ExtraParameters.process(extraParameters, clientExecutable);
        return (T)((IBaseMetaType)clientExecutable.execute());
    }

    public <T extends IBaseMetaType> T add(T meta, IIdType id, Map<ExtraParameters, Object> extraParameters) {
        IClientExecutable clientExecutable = this.client.meta().add().onResource(id).meta(meta);
        ExtraParameters.process(extraParameters, clientExecutable);
        return (T)((IBaseMetaType)clientExecutable.execute());
    }

    public <T extends IBaseMetaType> T delete(T meta, IIdType id, Map<ExtraParameters, Object> extraParameters) {
        IClientExecutable clientExecutable = this.client.meta().delete().onResource(id).meta(meta);
        ExtraParameters.process(extraParameters, clientExecutable);
        return (T)((IBaseMetaType)clientExecutable.execute());
    }
}

