/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.fhir.api;

import ca.uhn.fhir.rest.api.MethodOutcome;
import ca.uhn.fhir.rest.client.api.IGenericClient;
import ca.uhn.fhir.rest.gclient.IValidateUntyped;
import java.util.Map;
import org.apache.camel.component.fhir.api.ExtraParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class FhirValidate {
    private final IGenericClient client;

    public FhirValidate(IGenericClient client) {
        this.client = client;
    }

    public MethodOutcome resource(IBaseResource resource, Map<ExtraParameters, Object> extraParameters) {
        IValidateUntyped validateUntyped = this.client.validate().resource(resource);
        ExtraParameters.process(extraParameters, validateUntyped);
        return (MethodOutcome)validateUntyped.execute();
    }

    public MethodOutcome resource(String resourceAsString, Map<ExtraParameters, Object> extraParameters) {
        IValidateUntyped validateUntyped = this.client.validate().resource(resourceAsString);
        ExtraParameters.process(extraParameters, validateUntyped);
        return (MethodOutcome)validateUntyped.execute();
    }
}

