/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.fhir.api;

import ca.uhn.fhir.rest.client.api.IGenericClient;
import ca.uhn.fhir.rest.gclient.IReadExecutable;
import ca.uhn.fhir.rest.gclient.IReadIfNoneMatch;
import ca.uhn.fhir.rest.gclient.IReadTyped;
import java.util.Map;
import org.apache.camel.component.fhir.api.ExtraParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FhirRead {
    private static final Logger LOG = LoggerFactory.getLogger(FhirRead.class);
    private final IGenericClient client;

    public FhirRead(IGenericClient client) {
        this.client = client;
    }

    public IBaseResource resourceById(Class<IBaseResource> resource, IIdType id, String ifVersionMatches, Boolean returnNull, IBaseResource returnResource, Boolean throwError, Map<ExtraParameters, Object> extraParameters) {
        IReadExecutable readExecutable = this.client.read().resource(resource).withId(id);
        ExtraParameters.process(extraParameters, readExecutable);
        return this.processOptionalParams(ifVersionMatches, returnNull, returnResource, throwError, (IReadExecutable<IBaseResource>)readExecutable);
    }

    public IBaseResource resourceById(String resourceClass, IIdType id, String ifVersionMatches, Boolean returnNull, IBaseResource returnResource, Boolean throwError, Map<ExtraParameters, Object> extraParameters) {
        IReadExecutable readExecutable = this.client.read().resource(resourceClass).withId(id);
        ExtraParameters.process(extraParameters, readExecutable);
        return this.processOptionalParams(ifVersionMatches, returnNull, returnResource, throwError, (IReadExecutable<IBaseResource>)readExecutable);
    }

    public IBaseResource resourceById(Class<IBaseResource> resource, String stringId, String version, String ifVersionMatches, Boolean returnNull, IBaseResource returnResource, Boolean throwError, Map<ExtraParameters, Object> extraParameters) {
        IReadTyped readTyped = this.client.read().resource(resource);
        IReadExecutable<IBaseResource> readExecutable = this.readWithOptionalVersion(stringId, (IReadTyped<IBaseResource>)readTyped, version);
        ExtraParameters.process(extraParameters, readExecutable);
        return this.processOptionalParams(ifVersionMatches, returnNull, returnResource, throwError, readExecutable);
    }

    public IBaseResource resourceById(String resourceClass, String stringId, String ifVersionMatches, String version, Boolean returnNull, IBaseResource returnResource, Boolean throwError, Map<ExtraParameters, Object> extraParameters) {
        IReadTyped resource = this.client.read().resource(resourceClass);
        IReadExecutable<IBaseResource> readExecutable = this.readWithOptionalVersion(stringId, (IReadTyped<IBaseResource>)resource, version);
        ExtraParameters.process(extraParameters, readExecutable);
        return this.processOptionalParams(ifVersionMatches, returnNull, returnResource, throwError, readExecutable);
    }

    public IBaseResource resourceById(Class<IBaseResource> resource, Long longId, String ifVersionMatches, Boolean returnNull, IBaseResource returnResource, Boolean throwError, Map<ExtraParameters, Object> extraParameters) {
        IReadExecutable readExecutable = this.client.read().resource(resource).withId(longId);
        ExtraParameters.process(extraParameters, readExecutable);
        return this.processOptionalParams(ifVersionMatches, returnNull, returnResource, throwError, (IReadExecutable<IBaseResource>)readExecutable);
    }

    public IBaseResource resourceById(String resourceClass, Long longId, String ifVersionMatches, Boolean returnNull, IBaseResource returnResource, Boolean throwError, Map<ExtraParameters, Object> extraParameters) {
        IReadExecutable readExecutable = this.client.read().resource(resourceClass).withId(longId);
        ExtraParameters.process(extraParameters, readExecutable);
        return this.processOptionalParams(ifVersionMatches, returnNull, returnResource, throwError, (IReadExecutable<IBaseResource>)readExecutable);
    }

    public IBaseResource resourceByUrl(Class<IBaseResource> resource, IIdType iUrl, String ifVersionMatches, Boolean returnNull, IBaseResource returnResource, Boolean throwError, Map<ExtraParameters, Object> extraParameters) {
        IReadExecutable readExecutable = this.client.read().resource(resource).withUrl(iUrl);
        ExtraParameters.process(extraParameters, readExecutable);
        return this.processOptionalParams(ifVersionMatches, returnNull, returnResource, throwError, (IReadExecutable<IBaseResource>)readExecutable);
    }

    public IBaseResource resourceByUrl(String resourceClass, IIdType iUrl, String ifVersionMatches, Boolean returnNull, IBaseResource returnResource, Boolean throwError, Map<ExtraParameters, Object> extraParameters) {
        IReadExecutable readExecutable = this.client.read().resource(resourceClass).withUrl(iUrl);
        ExtraParameters.process(extraParameters, readExecutable);
        return this.processOptionalParams(ifVersionMatches, returnNull, returnResource, throwError, (IReadExecutable<IBaseResource>)readExecutable);
    }

    public IBaseResource resourceByUrl(Class<IBaseResource> resource, String url, String ifVersionMatches, Boolean returnNull, IBaseResource returnResource, Boolean throwError, Map<ExtraParameters, Object> extraParameters) {
        IReadExecutable readExecutable = this.client.read().resource(resource).withUrl(url);
        ExtraParameters.process(extraParameters, readExecutable);
        return this.processOptionalParams(ifVersionMatches, returnNull, returnResource, throwError, (IReadExecutable<IBaseResource>)readExecutable);
    }

    public IBaseResource resourceByUrl(String resourceClass, String url, String ifVersionMatches, Boolean returnNull, IBaseResource returnResource, Boolean throwError, Map<ExtraParameters, Object> extraParameters) {
        IReadExecutable readExecutable = this.client.read().resource(resourceClass).withUrl(url);
        ExtraParameters.process(extraParameters, readExecutable);
        return this.processOptionalParams(ifVersionMatches, returnNull, returnResource, throwError, (IReadExecutable<IBaseResource>)readExecutable);
    }

    private IBaseResource processOptionalParams(String ifVersionMatches, Boolean returnNull, IBaseResource returnResource, Boolean throwError, IReadExecutable<IBaseResource> readExecutable) {
        if (ifVersionMatches != null) {
            IReadIfNoneMatch tiReadIfNoneMatch = readExecutable.ifVersionMatches(ifVersionMatches);
            if (returnNull != null && returnNull.booleanValue()) {
                return (IBaseResource)tiReadIfNoneMatch.returnNull().execute();
            }
            if (returnResource != null) {
                return (IBaseResource)tiReadIfNoneMatch.returnResource(returnResource).execute();
            }
            if (throwError != null) {
                return (IBaseResource)tiReadIfNoneMatch.throwNotModifiedException().execute();
            }
            LOG.warn("No operation was specified with the If-None-Match header, ignoring");
        }
        return (IBaseResource)readExecutable.execute();
    }

    private IReadExecutable<IBaseResource> readWithOptionalVersion(String stringId, IReadTyped<IBaseResource> resource, String version) {
        if (version != null) {
            return resource.withIdAndVersion(stringId, version);
        }
        return resource.withId(stringId);
    }
}

