/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.camel.ExchangePattern;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.component.aws2.kinesis.Kinesis2ShardClosedStrategyEnum;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.PollingConsumerPollStrategy;
import software.amazon.awssdk.core.Protocol;
import software.amazon.awssdk.services.cloudwatch.CloudWatchAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.kinesis.KinesisClient;
import software.amazon.awssdk.services.kinesis.model.ShardIteratorType;

public interface Kinesis2EndpointBuilderFactory {
    public static Kinesis2EndpointBuilder endpointBuilder(String componentName, String path) {
        class Kinesis2EndpointBuilderImpl
        extends AbstractEndpointBuilder
        implements Kinesis2EndpointBuilder,
        AdvancedKinesis2EndpointBuilder {
            final /* synthetic */ String val$componentName;

            public Kinesis2EndpointBuilderImpl(String path, String string) {
                this.val$componentName = string;
                super(string, path);
            }
        }
        return new Kinesis2EndpointBuilderImpl(path, componentName);
    }

    public static class Kinesis2HeaderNameBuilder {
        private static final Kinesis2HeaderNameBuilder INSTANCE = new Kinesis2HeaderNameBuilder();

        public String awsKinesisSequenceNumber() {
            return "CamelAwsKinesisSequenceNumber";
        }

        public String awsKinesisApproximateArrivalTimestamp() {
            return "CamelAwsKinesisApproximateArrivalTimestamp";
        }

        public String awsKinesisPartitionKey() {
            return "CamelAwsKinesisPartitionKey";
        }

        public String messageTimestamp() {
            return "CamelMessageTimestamp";
        }

        public String kinesisDbResumeAction() {
            return "CamelKinesisDbResumeAction";
        }

        public String awsKinesisShardId() {
            return "CamelAwsKinesisShardId";
        }
    }

    public static interface Kinesis2Builders {
        default public Kinesis2HeaderNameBuilder aws2Kinesis() {
            return Kinesis2HeaderNameBuilder.INSTANCE;
        }

        default public Kinesis2EndpointBuilder aws2Kinesis(String path) {
            return Kinesis2EndpointBuilderFactory.endpointBuilder("aws2-kinesis", path);
        }

        default public Kinesis2EndpointBuilder aws2Kinesis(String componentName, String path) {
            return Kinesis2EndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }

    public static interface AdvancedKinesis2EndpointBuilder
    extends AdvancedKinesis2EndpointConsumerBuilder,
    AdvancedKinesis2EndpointProducerBuilder {
        @Override
        default public Kinesis2EndpointBuilder basic() {
            return (Kinesis2EndpointBuilder)((Object)this);
        }

        @Override
        default public AdvancedKinesis2EndpointBuilder amazonKinesisClient(KinesisClient amazonKinesisClient) {
            this.doSetProperty("amazonKinesisClient", amazonKinesisClient);
            return this;
        }

        @Override
        default public AdvancedKinesis2EndpointBuilder amazonKinesisClient(String amazonKinesisClient) {
            this.doSetProperty("amazonKinesisClient", amazonKinesisClient);
            return this;
        }

        @Override
        default public AdvancedKinesis2EndpointBuilder asyncClient(boolean asyncClient) {
            this.doSetProperty("asyncClient", asyncClient);
            return this;
        }

        @Override
        default public AdvancedKinesis2EndpointBuilder asyncClient(String asyncClient) {
            this.doSetProperty("asyncClient", asyncClient);
            return this;
        }

        @Override
        default public AdvancedKinesis2EndpointBuilder cloudWatchAsyncClient(CloudWatchAsyncClient cloudWatchAsyncClient) {
            this.doSetProperty("cloudWatchAsyncClient", cloudWatchAsyncClient);
            return this;
        }

        @Override
        default public AdvancedKinesis2EndpointBuilder cloudWatchAsyncClient(String cloudWatchAsyncClient) {
            this.doSetProperty("cloudWatchAsyncClient", cloudWatchAsyncClient);
            return this;
        }

        @Override
        default public AdvancedKinesis2EndpointBuilder dynamoDbAsyncClient(DynamoDbAsyncClient dynamoDbAsyncClient) {
            this.doSetProperty("dynamoDbAsyncClient", dynamoDbAsyncClient);
            return this;
        }

        @Override
        default public AdvancedKinesis2EndpointBuilder dynamoDbAsyncClient(String dynamoDbAsyncClient) {
            this.doSetProperty("dynamoDbAsyncClient", dynamoDbAsyncClient);
            return this;
        }

        @Override
        default public AdvancedKinesis2EndpointBuilder kclDisableCloudwatchMetricsExport(boolean kclDisableCloudwatchMetricsExport) {
            this.doSetProperty("kclDisableCloudwatchMetricsExport", kclDisableCloudwatchMetricsExport);
            return this;
        }

        @Override
        default public AdvancedKinesis2EndpointBuilder kclDisableCloudwatchMetricsExport(String kclDisableCloudwatchMetricsExport) {
            this.doSetProperty("kclDisableCloudwatchMetricsExport", kclDisableCloudwatchMetricsExport);
            return this;
        }

        @Override
        default public AdvancedKinesis2EndpointBuilder useKclConsumers(boolean useKclConsumers) {
            this.doSetProperty("useKclConsumers", useKclConsumers);
            return this;
        }

        @Override
        default public AdvancedKinesis2EndpointBuilder useKclConsumers(String useKclConsumers) {
            this.doSetProperty("useKclConsumers", useKclConsumers);
            return this;
        }
    }

    public static interface Kinesis2EndpointBuilder
    extends Kinesis2EndpointConsumerBuilder,
    Kinesis2EndpointProducerBuilder {
        @Override
        default public AdvancedKinesis2EndpointBuilder advanced() {
            return (AdvancedKinesis2EndpointBuilder)((Object)this);
        }

        @Override
        default public Kinesis2EndpointBuilder cborEnabled(boolean cborEnabled) {
            this.doSetProperty("cborEnabled", cborEnabled);
            return this;
        }

        @Override
        default public Kinesis2EndpointBuilder cborEnabled(String cborEnabled) {
            this.doSetProperty("cborEnabled", cborEnabled);
            return this;
        }

        @Override
        default public Kinesis2EndpointBuilder overrideEndpoint(boolean overrideEndpoint) {
            this.doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }

        @Override
        default public Kinesis2EndpointBuilder overrideEndpoint(String overrideEndpoint) {
            this.doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }

        @Override
        default public Kinesis2EndpointBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        @Override
        default public Kinesis2EndpointBuilder uriEndpointOverride(String uriEndpointOverride) {
            this.doSetProperty("uriEndpointOverride", uriEndpointOverride);
            return this;
        }

        @Override
        default public Kinesis2EndpointBuilder proxyHost(String proxyHost) {
            this.doSetProperty("proxyHost", proxyHost);
            return this;
        }

        @Override
        default public Kinesis2EndpointBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        @Override
        default public Kinesis2EndpointBuilder proxyPort(String proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        @Override
        default public Kinesis2EndpointBuilder proxyProtocol(Protocol proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        @Override
        default public Kinesis2EndpointBuilder proxyProtocol(String proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        @Override
        default public Kinesis2EndpointBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        @Override
        default public Kinesis2EndpointBuilder profileCredentialsName(String profileCredentialsName) {
            this.doSetProperty("profileCredentialsName", profileCredentialsName);
            return this;
        }

        @Override
        default public Kinesis2EndpointBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }

        @Override
        default public Kinesis2EndpointBuilder sessionToken(String sessionToken) {
            this.doSetProperty("sessionToken", sessionToken);
            return this;
        }

        @Override
        default public Kinesis2EndpointBuilder trustAllCertificates(boolean trustAllCertificates) {
            this.doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }

        @Override
        default public Kinesis2EndpointBuilder trustAllCertificates(String trustAllCertificates) {
            this.doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }

        @Override
        default public Kinesis2EndpointBuilder useDefaultCredentialsProvider(boolean useDefaultCredentialsProvider) {
            this.doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }

        @Override
        default public Kinesis2EndpointBuilder useDefaultCredentialsProvider(String useDefaultCredentialsProvider) {
            this.doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }

        @Override
        default public Kinesis2EndpointBuilder useProfileCredentialsProvider(boolean useProfileCredentialsProvider) {
            this.doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }

        @Override
        default public Kinesis2EndpointBuilder useProfileCredentialsProvider(String useProfileCredentialsProvider) {
            this.doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }

        @Override
        default public Kinesis2EndpointBuilder useSessionCredentials(boolean useSessionCredentials) {
            this.doSetProperty("useSessionCredentials", useSessionCredentials);
            return this;
        }

        @Override
        default public Kinesis2EndpointBuilder useSessionCredentials(String useSessionCredentials) {
            this.doSetProperty("useSessionCredentials", useSessionCredentials);
            return this;
        }
    }

    public static interface AdvancedKinesis2EndpointProducerBuilder
    extends EndpointProducerBuilder {
        default public Kinesis2EndpointProducerBuilder basic() {
            return (Kinesis2EndpointProducerBuilder)((Object)this);
        }

        default public AdvancedKinesis2EndpointProducerBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public AdvancedKinesis2EndpointProducerBuilder lazyStartProducer(String lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public AdvancedKinesis2EndpointProducerBuilder amazonKinesisClient(KinesisClient amazonKinesisClient) {
            this.doSetProperty("amazonKinesisClient", amazonKinesisClient);
            return this;
        }

        default public AdvancedKinesis2EndpointProducerBuilder amazonKinesisClient(String amazonKinesisClient) {
            this.doSetProperty("amazonKinesisClient", amazonKinesisClient);
            return this;
        }

        default public AdvancedKinesis2EndpointProducerBuilder asyncClient(boolean asyncClient) {
            this.doSetProperty("asyncClient", asyncClient);
            return this;
        }

        default public AdvancedKinesis2EndpointProducerBuilder asyncClient(String asyncClient) {
            this.doSetProperty("asyncClient", asyncClient);
            return this;
        }

        default public AdvancedKinesis2EndpointProducerBuilder cloudWatchAsyncClient(CloudWatchAsyncClient cloudWatchAsyncClient) {
            this.doSetProperty("cloudWatchAsyncClient", cloudWatchAsyncClient);
            return this;
        }

        default public AdvancedKinesis2EndpointProducerBuilder cloudWatchAsyncClient(String cloudWatchAsyncClient) {
            this.doSetProperty("cloudWatchAsyncClient", cloudWatchAsyncClient);
            return this;
        }

        default public AdvancedKinesis2EndpointProducerBuilder dynamoDbAsyncClient(DynamoDbAsyncClient dynamoDbAsyncClient) {
            this.doSetProperty("dynamoDbAsyncClient", dynamoDbAsyncClient);
            return this;
        }

        default public AdvancedKinesis2EndpointProducerBuilder dynamoDbAsyncClient(String dynamoDbAsyncClient) {
            this.doSetProperty("dynamoDbAsyncClient", dynamoDbAsyncClient);
            return this;
        }

        default public AdvancedKinesis2EndpointProducerBuilder kclDisableCloudwatchMetricsExport(boolean kclDisableCloudwatchMetricsExport) {
            this.doSetProperty("kclDisableCloudwatchMetricsExport", kclDisableCloudwatchMetricsExport);
            return this;
        }

        default public AdvancedKinesis2EndpointProducerBuilder kclDisableCloudwatchMetricsExport(String kclDisableCloudwatchMetricsExport) {
            this.doSetProperty("kclDisableCloudwatchMetricsExport", kclDisableCloudwatchMetricsExport);
            return this;
        }

        default public AdvancedKinesis2EndpointProducerBuilder useKclConsumers(boolean useKclConsumers) {
            this.doSetProperty("useKclConsumers", useKclConsumers);
            return this;
        }

        default public AdvancedKinesis2EndpointProducerBuilder useKclConsumers(String useKclConsumers) {
            this.doSetProperty("useKclConsumers", useKclConsumers);
            return this;
        }
    }

    public static interface Kinesis2EndpointProducerBuilder
    extends EndpointProducerBuilder {
        default public AdvancedKinesis2EndpointProducerBuilder advanced() {
            return (AdvancedKinesis2EndpointProducerBuilder)((Object)this);
        }

        default public Kinesis2EndpointProducerBuilder cborEnabled(boolean cborEnabled) {
            this.doSetProperty("cborEnabled", cborEnabled);
            return this;
        }

        default public Kinesis2EndpointProducerBuilder cborEnabled(String cborEnabled) {
            this.doSetProperty("cborEnabled", cborEnabled);
            return this;
        }

        default public Kinesis2EndpointProducerBuilder overrideEndpoint(boolean overrideEndpoint) {
            this.doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }

        default public Kinesis2EndpointProducerBuilder overrideEndpoint(String overrideEndpoint) {
            this.doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }

        default public Kinesis2EndpointProducerBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public Kinesis2EndpointProducerBuilder uriEndpointOverride(String uriEndpointOverride) {
            this.doSetProperty("uriEndpointOverride", uriEndpointOverride);
            return this;
        }

        default public Kinesis2EndpointProducerBuilder proxyHost(String proxyHost) {
            this.doSetProperty("proxyHost", proxyHost);
            return this;
        }

        default public Kinesis2EndpointProducerBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public Kinesis2EndpointProducerBuilder proxyPort(String proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public Kinesis2EndpointProducerBuilder proxyProtocol(Protocol proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public Kinesis2EndpointProducerBuilder proxyProtocol(String proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public Kinesis2EndpointProducerBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public Kinesis2EndpointProducerBuilder profileCredentialsName(String profileCredentialsName) {
            this.doSetProperty("profileCredentialsName", profileCredentialsName);
            return this;
        }

        default public Kinesis2EndpointProducerBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }

        default public Kinesis2EndpointProducerBuilder sessionToken(String sessionToken) {
            this.doSetProperty("sessionToken", sessionToken);
            return this;
        }

        default public Kinesis2EndpointProducerBuilder trustAllCertificates(boolean trustAllCertificates) {
            this.doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }

        default public Kinesis2EndpointProducerBuilder trustAllCertificates(String trustAllCertificates) {
            this.doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }

        default public Kinesis2EndpointProducerBuilder useDefaultCredentialsProvider(boolean useDefaultCredentialsProvider) {
            this.doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }

        default public Kinesis2EndpointProducerBuilder useDefaultCredentialsProvider(String useDefaultCredentialsProvider) {
            this.doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }

        default public Kinesis2EndpointProducerBuilder useProfileCredentialsProvider(boolean useProfileCredentialsProvider) {
            this.doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }

        default public Kinesis2EndpointProducerBuilder useProfileCredentialsProvider(String useProfileCredentialsProvider) {
            this.doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }

        default public Kinesis2EndpointProducerBuilder useSessionCredentials(boolean useSessionCredentials) {
            this.doSetProperty("useSessionCredentials", useSessionCredentials);
            return this;
        }

        default public Kinesis2EndpointProducerBuilder useSessionCredentials(String useSessionCredentials) {
            this.doSetProperty("useSessionCredentials", useSessionCredentials);
            return this;
        }
    }

    public static interface AdvancedKinesis2EndpointConsumerBuilder
    extends EndpointConsumerBuilder {
        default public Kinesis2EndpointConsumerBuilder basic() {
            return (Kinesis2EndpointConsumerBuilder)((Object)this);
        }

        default public AdvancedKinesis2EndpointConsumerBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public AdvancedKinesis2EndpointConsumerBuilder bridgeErrorHandler(String bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public AdvancedKinesis2EndpointConsumerBuilder exceptionHandler(ExceptionHandler exceptionHandler) {
            this.doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }

        default public AdvancedKinesis2EndpointConsumerBuilder exceptionHandler(String exceptionHandler) {
            this.doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }

        default public AdvancedKinesis2EndpointConsumerBuilder exchangePattern(ExchangePattern exchangePattern) {
            this.doSetProperty("exchangePattern", exchangePattern);
            return this;
        }

        default public AdvancedKinesis2EndpointConsumerBuilder exchangePattern(String exchangePattern) {
            this.doSetProperty("exchangePattern", exchangePattern);
            return this;
        }

        default public AdvancedKinesis2EndpointConsumerBuilder pollStrategy(PollingConsumerPollStrategy pollStrategy) {
            this.doSetProperty("pollStrategy", pollStrategy);
            return this;
        }

        default public AdvancedKinesis2EndpointConsumerBuilder pollStrategy(String pollStrategy) {
            this.doSetProperty("pollStrategy", pollStrategy);
            return this;
        }

        default public AdvancedKinesis2EndpointConsumerBuilder shardMonitorInterval(long shardMonitorInterval) {
            this.doSetProperty("shardMonitorInterval", shardMonitorInterval);
            return this;
        }

        default public AdvancedKinesis2EndpointConsumerBuilder shardMonitorInterval(String shardMonitorInterval) {
            this.doSetProperty("shardMonitorInterval", shardMonitorInterval);
            return this;
        }

        default public AdvancedKinesis2EndpointConsumerBuilder amazonKinesisClient(KinesisClient amazonKinesisClient) {
            this.doSetProperty("amazonKinesisClient", amazonKinesisClient);
            return this;
        }

        default public AdvancedKinesis2EndpointConsumerBuilder amazonKinesisClient(String amazonKinesisClient) {
            this.doSetProperty("amazonKinesisClient", amazonKinesisClient);
            return this;
        }

        default public AdvancedKinesis2EndpointConsumerBuilder asyncClient(boolean asyncClient) {
            this.doSetProperty("asyncClient", asyncClient);
            return this;
        }

        default public AdvancedKinesis2EndpointConsumerBuilder asyncClient(String asyncClient) {
            this.doSetProperty("asyncClient", asyncClient);
            return this;
        }

        default public AdvancedKinesis2EndpointConsumerBuilder cloudWatchAsyncClient(CloudWatchAsyncClient cloudWatchAsyncClient) {
            this.doSetProperty("cloudWatchAsyncClient", cloudWatchAsyncClient);
            return this;
        }

        default public AdvancedKinesis2EndpointConsumerBuilder cloudWatchAsyncClient(String cloudWatchAsyncClient) {
            this.doSetProperty("cloudWatchAsyncClient", cloudWatchAsyncClient);
            return this;
        }

        default public AdvancedKinesis2EndpointConsumerBuilder dynamoDbAsyncClient(DynamoDbAsyncClient dynamoDbAsyncClient) {
            this.doSetProperty("dynamoDbAsyncClient", dynamoDbAsyncClient);
            return this;
        }

        default public AdvancedKinesis2EndpointConsumerBuilder dynamoDbAsyncClient(String dynamoDbAsyncClient) {
            this.doSetProperty("dynamoDbAsyncClient", dynamoDbAsyncClient);
            return this;
        }

        default public AdvancedKinesis2EndpointConsumerBuilder kclDisableCloudwatchMetricsExport(boolean kclDisableCloudwatchMetricsExport) {
            this.doSetProperty("kclDisableCloudwatchMetricsExport", kclDisableCloudwatchMetricsExport);
            return this;
        }

        default public AdvancedKinesis2EndpointConsumerBuilder kclDisableCloudwatchMetricsExport(String kclDisableCloudwatchMetricsExport) {
            this.doSetProperty("kclDisableCloudwatchMetricsExport", kclDisableCloudwatchMetricsExport);
            return this;
        }

        default public AdvancedKinesis2EndpointConsumerBuilder useKclConsumers(boolean useKclConsumers) {
            this.doSetProperty("useKclConsumers", useKclConsumers);
            return this;
        }

        default public AdvancedKinesis2EndpointConsumerBuilder useKclConsumers(String useKclConsumers) {
            this.doSetProperty("useKclConsumers", useKclConsumers);
            return this;
        }
    }

    public static interface Kinesis2EndpointConsumerBuilder
    extends EndpointConsumerBuilder {
        default public AdvancedKinesis2EndpointConsumerBuilder advanced() {
            return (AdvancedKinesis2EndpointConsumerBuilder)((Object)this);
        }

        default public Kinesis2EndpointConsumerBuilder cborEnabled(boolean cborEnabled) {
            this.doSetProperty("cborEnabled", cborEnabled);
            return this;
        }

        default public Kinesis2EndpointConsumerBuilder cborEnabled(String cborEnabled) {
            this.doSetProperty("cborEnabled", cborEnabled);
            return this;
        }

        default public Kinesis2EndpointConsumerBuilder overrideEndpoint(boolean overrideEndpoint) {
            this.doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }

        default public Kinesis2EndpointConsumerBuilder overrideEndpoint(String overrideEndpoint) {
            this.doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }

        default public Kinesis2EndpointConsumerBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public Kinesis2EndpointConsumerBuilder uriEndpointOverride(String uriEndpointOverride) {
            this.doSetProperty("uriEndpointOverride", uriEndpointOverride);
            return this;
        }

        default public Kinesis2EndpointConsumerBuilder iteratorType(ShardIteratorType iteratorType) {
            this.doSetProperty("iteratorType", iteratorType);
            return this;
        }

        default public Kinesis2EndpointConsumerBuilder iteratorType(String iteratorType) {
            this.doSetProperty("iteratorType", iteratorType);
            return this;
        }

        default public Kinesis2EndpointConsumerBuilder maxResultsPerRequest(int maxResultsPerRequest) {
            this.doSetProperty("maxResultsPerRequest", maxResultsPerRequest);
            return this;
        }

        default public Kinesis2EndpointConsumerBuilder maxResultsPerRequest(String maxResultsPerRequest) {
            this.doSetProperty("maxResultsPerRequest", maxResultsPerRequest);
            return this;
        }

        default public Kinesis2EndpointConsumerBuilder messageTimestamp(String messageTimestamp) {
            this.doSetProperty("messageTimestamp", messageTimestamp);
            return this;
        }

        default public Kinesis2EndpointConsumerBuilder sendEmptyMessageWhenIdle(boolean sendEmptyMessageWhenIdle) {
            this.doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }

        default public Kinesis2EndpointConsumerBuilder sendEmptyMessageWhenIdle(String sendEmptyMessageWhenIdle) {
            this.doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }

        default public Kinesis2EndpointConsumerBuilder sequenceNumber(String sequenceNumber) {
            this.doSetProperty("sequenceNumber", sequenceNumber);
            return this;
        }

        default public Kinesis2EndpointConsumerBuilder shardClosed(Kinesis2ShardClosedStrategyEnum shardClosed) {
            this.doSetProperty("shardClosed", shardClosed);
            return this;
        }

        default public Kinesis2EndpointConsumerBuilder shardClosed(String shardClosed) {
            this.doSetProperty("shardClosed", shardClosed);
            return this;
        }

        default public Kinesis2EndpointConsumerBuilder shardId(String shardId) {
            this.doSetProperty("shardId", shardId);
            return this;
        }

        default public Kinesis2EndpointConsumerBuilder proxyHost(String proxyHost) {
            this.doSetProperty("proxyHost", proxyHost);
            return this;
        }

        default public Kinesis2EndpointConsumerBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public Kinesis2EndpointConsumerBuilder proxyPort(String proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public Kinesis2EndpointConsumerBuilder proxyProtocol(Protocol proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public Kinesis2EndpointConsumerBuilder proxyProtocol(String proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public Kinesis2EndpointConsumerBuilder backoffErrorThreshold(int backoffErrorThreshold) {
            this.doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }

        default public Kinesis2EndpointConsumerBuilder backoffErrorThreshold(String backoffErrorThreshold) {
            this.doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }

        default public Kinesis2EndpointConsumerBuilder backoffIdleThreshold(int backoffIdleThreshold) {
            this.doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }

        default public Kinesis2EndpointConsumerBuilder backoffIdleThreshold(String backoffIdleThreshold) {
            this.doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }

        default public Kinesis2EndpointConsumerBuilder backoffMultiplier(int backoffMultiplier) {
            this.doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }

        default public Kinesis2EndpointConsumerBuilder backoffMultiplier(String backoffMultiplier) {
            this.doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }

        default public Kinesis2EndpointConsumerBuilder delay(long delay) {
            this.doSetProperty("delay", delay);
            return this;
        }

        default public Kinesis2EndpointConsumerBuilder delay(String delay) {
            this.doSetProperty("delay", delay);
            return this;
        }

        default public Kinesis2EndpointConsumerBuilder greedy(boolean greedy) {
            this.doSetProperty("greedy", greedy);
            return this;
        }

        default public Kinesis2EndpointConsumerBuilder greedy(String greedy) {
            this.doSetProperty("greedy", greedy);
            return this;
        }

        default public Kinesis2EndpointConsumerBuilder initialDelay(long initialDelay) {
            this.doSetProperty("initialDelay", initialDelay);
            return this;
        }

        default public Kinesis2EndpointConsumerBuilder initialDelay(String initialDelay) {
            this.doSetProperty("initialDelay", initialDelay);
            return this;
        }

        default public Kinesis2EndpointConsumerBuilder repeatCount(long repeatCount) {
            this.doSetProperty("repeatCount", repeatCount);
            return this;
        }

        default public Kinesis2EndpointConsumerBuilder repeatCount(String repeatCount) {
            this.doSetProperty("repeatCount", repeatCount);
            return this;
        }

        default public Kinesis2EndpointConsumerBuilder runLoggingLevel(LoggingLevel runLoggingLevel) {
            this.doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }

        default public Kinesis2EndpointConsumerBuilder runLoggingLevel(String runLoggingLevel) {
            this.doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }

        default public Kinesis2EndpointConsumerBuilder scheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
            this.doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }

        default public Kinesis2EndpointConsumerBuilder scheduledExecutorService(String scheduledExecutorService) {
            this.doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }

        default public Kinesis2EndpointConsumerBuilder scheduler(Object scheduler) {
            this.doSetProperty("scheduler", scheduler);
            return this;
        }

        default public Kinesis2EndpointConsumerBuilder scheduler(String scheduler) {
            this.doSetProperty("scheduler", scheduler);
            return this;
        }

        default public Kinesis2EndpointConsumerBuilder schedulerProperties(String key, Object value) {
            this.doSetMultiValueProperty("schedulerProperties", "scheduler." + key, value);
            return this;
        }

        default public Kinesis2EndpointConsumerBuilder schedulerProperties(Map values) {
            this.doSetMultiValueProperties("schedulerProperties", "scheduler.", values);
            return this;
        }

        default public Kinesis2EndpointConsumerBuilder startScheduler(boolean startScheduler) {
            this.doSetProperty("startScheduler", startScheduler);
            return this;
        }

        default public Kinesis2EndpointConsumerBuilder startScheduler(String startScheduler) {
            this.doSetProperty("startScheduler", startScheduler);
            return this;
        }

        default public Kinesis2EndpointConsumerBuilder timeUnit(TimeUnit timeUnit) {
            this.doSetProperty("timeUnit", (Object)timeUnit);
            return this;
        }

        default public Kinesis2EndpointConsumerBuilder timeUnit(String timeUnit) {
            this.doSetProperty("timeUnit", timeUnit);
            return this;
        }

        default public Kinesis2EndpointConsumerBuilder useFixedDelay(boolean useFixedDelay) {
            this.doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }

        default public Kinesis2EndpointConsumerBuilder useFixedDelay(String useFixedDelay) {
            this.doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }

        default public Kinesis2EndpointConsumerBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public Kinesis2EndpointConsumerBuilder profileCredentialsName(String profileCredentialsName) {
            this.doSetProperty("profileCredentialsName", profileCredentialsName);
            return this;
        }

        default public Kinesis2EndpointConsumerBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }

        default public Kinesis2EndpointConsumerBuilder sessionToken(String sessionToken) {
            this.doSetProperty("sessionToken", sessionToken);
            return this;
        }

        default public Kinesis2EndpointConsumerBuilder trustAllCertificates(boolean trustAllCertificates) {
            this.doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }

        default public Kinesis2EndpointConsumerBuilder trustAllCertificates(String trustAllCertificates) {
            this.doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }

        default public Kinesis2EndpointConsumerBuilder useDefaultCredentialsProvider(boolean useDefaultCredentialsProvider) {
            this.doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }

        default public Kinesis2EndpointConsumerBuilder useDefaultCredentialsProvider(String useDefaultCredentialsProvider) {
            this.doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }

        default public Kinesis2EndpointConsumerBuilder useProfileCredentialsProvider(boolean useProfileCredentialsProvider) {
            this.doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }

        default public Kinesis2EndpointConsumerBuilder useProfileCredentialsProvider(String useProfileCredentialsProvider) {
            this.doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }

        default public Kinesis2EndpointConsumerBuilder useSessionCredentials(boolean useSessionCredentials) {
            this.doSetProperty("useSessionCredentials", useSessionCredentials);
            return this;
        }

        default public Kinesis2EndpointConsumerBuilder useSessionCredentials(String useSessionCredentials) {
            this.doSetProperty("useSessionCredentials", useSessionCredentials);
            return this;
        }
    }
}

