/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.security.PrivateKey;
import java.security.PublicKey;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.eclipse.californium.scandium.dtls.pskstore.PskStore;
import org.eclipse.californium.scandium.dtls.rpkstore.TrustedRpkStore;

public interface CoAPEndpointBuilderFactory {
    public static CoAPEndpointBuilder endpointBuilder(String componentName, String path) {
        class CoAPEndpointBuilderImpl
        extends AbstractEndpointBuilder
        implements CoAPEndpointBuilder,
        AdvancedCoAPEndpointBuilder {
            final /* synthetic */ String val$componentName;

            public CoAPEndpointBuilderImpl(String path, String string) {
                this.val$componentName = string;
                super(string, path);
            }
        }
        return new CoAPEndpointBuilderImpl(path, componentName);
    }

    public static class CoAPHeaderNameBuilder {
        private static final CoAPHeaderNameBuilder INSTANCE = new CoAPHeaderNameBuilder();

        public String coapETag() {
            return "CamelCoapETag";
        }

        public String coapMaxAge() {
            return "CamelCoapMaxAge";
        }

        public String coapMethod() {
            return "CamelCoapMethod";
        }

        public String coapResponseCode() {
            return "CamelCoapResponseCode";
        }

        public String coapUri() {
            return "CamelCoapUri";
        }

        public String contentType() {
            return "Content-Type";
        }
    }

    public static interface CoAPBuilders {
        default public CoAPHeaderNameBuilder coap() {
            return CoAPHeaderNameBuilder.INSTANCE;
        }

        default public CoAPEndpointBuilder coap(String path) {
            return CoAPEndpointBuilderFactory.endpointBuilder("coap", path);
        }

        default public CoAPEndpointBuilder coap(String componentName, String path) {
            return CoAPEndpointBuilderFactory.endpointBuilder(componentName, path);
        }

        default public CoAPEndpointBuilder coaps(String path) {
            return CoAPEndpointBuilderFactory.endpointBuilder("coaps", path);
        }

        default public CoAPEndpointBuilder coapTcp(String path) {
            return CoAPEndpointBuilderFactory.endpointBuilder("coap+tcp", path);
        }

        default public CoAPEndpointBuilder coapsTcp(String path) {
            return CoAPEndpointBuilderFactory.endpointBuilder("coaps+tcp", path);
        }
    }

    public static interface AdvancedCoAPEndpointBuilder
    extends AdvancedCoAPEndpointConsumerBuilder,
    AdvancedCoAPEndpointProducerBuilder {
        @Override
        default public CoAPEndpointBuilder basic() {
            return (CoAPEndpointBuilder)((Object)this);
        }
    }

    public static interface CoAPEndpointBuilder
    extends CoAPEndpointConsumerBuilder,
    CoAPEndpointProducerBuilder {
        @Override
        default public AdvancedCoAPEndpointBuilder advanced() {
            return (AdvancedCoAPEndpointBuilder)((Object)this);
        }

        @Override
        default public CoAPEndpointBuilder alias(String alias) {
            this.doSetProperty("alias", alias);
            return this;
        }

        @Override
        default public CoAPEndpointBuilder cipherSuites(String cipherSuites) {
            this.doSetProperty("cipherSuites", cipherSuites);
            return this;
        }

        @Override
        default public CoAPEndpointBuilder clientAuthentication(String clientAuthentication) {
            this.doSetProperty("clientAuthentication", clientAuthentication);
            return this;
        }

        @Override
        default public CoAPEndpointBuilder privateKey(PrivateKey privateKey) {
            this.doSetProperty("privateKey", privateKey);
            return this;
        }

        @Override
        default public CoAPEndpointBuilder privateKey(String privateKey) {
            this.doSetProperty("privateKey", privateKey);
            return this;
        }

        @Override
        default public CoAPEndpointBuilder pskStore(PskStore pskStore) {
            this.doSetProperty("pskStore", pskStore);
            return this;
        }

        @Override
        default public CoAPEndpointBuilder pskStore(String pskStore) {
            this.doSetProperty("pskStore", pskStore);
            return this;
        }

        @Override
        default public CoAPEndpointBuilder publicKey(PublicKey publicKey) {
            this.doSetProperty("publicKey", publicKey);
            return this;
        }

        @Override
        default public CoAPEndpointBuilder publicKey(String publicKey) {
            this.doSetProperty("publicKey", publicKey);
            return this;
        }

        @Override
        default public CoAPEndpointBuilder recommendedCipherSuitesOnly(boolean recommendedCipherSuitesOnly) {
            this.doSetProperty("recommendedCipherSuitesOnly", recommendedCipherSuitesOnly);
            return this;
        }

        @Override
        default public CoAPEndpointBuilder recommendedCipherSuitesOnly(String recommendedCipherSuitesOnly) {
            this.doSetProperty("recommendedCipherSuitesOnly", recommendedCipherSuitesOnly);
            return this;
        }

        @Override
        default public CoAPEndpointBuilder sslContextParameters(SSLContextParameters sslContextParameters) {
            this.doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }

        @Override
        default public CoAPEndpointBuilder sslContextParameters(String sslContextParameters) {
            this.doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }

        @Override
        default public CoAPEndpointBuilder trustedRpkStore(TrustedRpkStore trustedRpkStore) {
            this.doSetProperty("trustedRpkStore", trustedRpkStore);
            return this;
        }

        @Override
        default public CoAPEndpointBuilder trustedRpkStore(String trustedRpkStore) {
            this.doSetProperty("trustedRpkStore", trustedRpkStore);
            return this;
        }
    }

    public static interface AdvancedCoAPEndpointProducerBuilder
    extends EndpointProducerBuilder {
        default public CoAPEndpointProducerBuilder basic() {
            return (CoAPEndpointProducerBuilder)((Object)this);
        }

        default public AdvancedCoAPEndpointProducerBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public AdvancedCoAPEndpointProducerBuilder lazyStartProducer(String lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    public static interface CoAPEndpointProducerBuilder
    extends EndpointProducerBuilder {
        default public AdvancedCoAPEndpointProducerBuilder advanced() {
            return (AdvancedCoAPEndpointProducerBuilder)((Object)this);
        }

        default public CoAPEndpointProducerBuilder notify(boolean notify) {
            this.doSetProperty("notify", notify);
            return this;
        }

        default public CoAPEndpointProducerBuilder notify(String notify) {
            this.doSetProperty("notify", notify);
            return this;
        }

        default public CoAPEndpointProducerBuilder alias(String alias) {
            this.doSetProperty("alias", alias);
            return this;
        }

        default public CoAPEndpointProducerBuilder cipherSuites(String cipherSuites) {
            this.doSetProperty("cipherSuites", cipherSuites);
            return this;
        }

        default public CoAPEndpointProducerBuilder clientAuthentication(String clientAuthentication) {
            this.doSetProperty("clientAuthentication", clientAuthentication);
            return this;
        }

        default public CoAPEndpointProducerBuilder privateKey(PrivateKey privateKey) {
            this.doSetProperty("privateKey", privateKey);
            return this;
        }

        default public CoAPEndpointProducerBuilder privateKey(String privateKey) {
            this.doSetProperty("privateKey", privateKey);
            return this;
        }

        default public CoAPEndpointProducerBuilder pskStore(PskStore pskStore) {
            this.doSetProperty("pskStore", pskStore);
            return this;
        }

        default public CoAPEndpointProducerBuilder pskStore(String pskStore) {
            this.doSetProperty("pskStore", pskStore);
            return this;
        }

        default public CoAPEndpointProducerBuilder publicKey(PublicKey publicKey) {
            this.doSetProperty("publicKey", publicKey);
            return this;
        }

        default public CoAPEndpointProducerBuilder publicKey(String publicKey) {
            this.doSetProperty("publicKey", publicKey);
            return this;
        }

        default public CoAPEndpointProducerBuilder recommendedCipherSuitesOnly(boolean recommendedCipherSuitesOnly) {
            this.doSetProperty("recommendedCipherSuitesOnly", recommendedCipherSuitesOnly);
            return this;
        }

        default public CoAPEndpointProducerBuilder recommendedCipherSuitesOnly(String recommendedCipherSuitesOnly) {
            this.doSetProperty("recommendedCipherSuitesOnly", recommendedCipherSuitesOnly);
            return this;
        }

        default public CoAPEndpointProducerBuilder sslContextParameters(SSLContextParameters sslContextParameters) {
            this.doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }

        default public CoAPEndpointProducerBuilder sslContextParameters(String sslContextParameters) {
            this.doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }

        default public CoAPEndpointProducerBuilder trustedRpkStore(TrustedRpkStore trustedRpkStore) {
            this.doSetProperty("trustedRpkStore", trustedRpkStore);
            return this;
        }

        default public CoAPEndpointProducerBuilder trustedRpkStore(String trustedRpkStore) {
            this.doSetProperty("trustedRpkStore", trustedRpkStore);
            return this;
        }
    }

    public static interface AdvancedCoAPEndpointConsumerBuilder
    extends EndpointConsumerBuilder {
        default public CoAPEndpointConsumerBuilder basic() {
            return (CoAPEndpointConsumerBuilder)((Object)this);
        }

        default public AdvancedCoAPEndpointConsumerBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public AdvancedCoAPEndpointConsumerBuilder bridgeErrorHandler(String bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public AdvancedCoAPEndpointConsumerBuilder exceptionHandler(ExceptionHandler exceptionHandler) {
            this.doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }

        default public AdvancedCoAPEndpointConsumerBuilder exceptionHandler(String exceptionHandler) {
            this.doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }

        default public AdvancedCoAPEndpointConsumerBuilder exchangePattern(ExchangePattern exchangePattern) {
            this.doSetProperty("exchangePattern", exchangePattern);
            return this;
        }

        default public AdvancedCoAPEndpointConsumerBuilder exchangePattern(String exchangePattern) {
            this.doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
    }

    public static interface CoAPEndpointConsumerBuilder
    extends EndpointConsumerBuilder {
        default public AdvancedCoAPEndpointConsumerBuilder advanced() {
            return (AdvancedCoAPEndpointConsumerBuilder)((Object)this);
        }

        default public CoAPEndpointConsumerBuilder coapMethodRestrict(String coapMethodRestrict) {
            this.doSetProperty("coapMethodRestrict", coapMethodRestrict);
            return this;
        }

        default public CoAPEndpointConsumerBuilder observable(boolean observable) {
            this.doSetProperty("observable", observable);
            return this;
        }

        default public CoAPEndpointConsumerBuilder observable(String observable) {
            this.doSetProperty("observable", observable);
            return this;
        }

        default public CoAPEndpointConsumerBuilder observe(boolean observe) {
            this.doSetProperty("observe", observe);
            return this;
        }

        default public CoAPEndpointConsumerBuilder observe(String observe) {
            this.doSetProperty("observe", observe);
            return this;
        }

        default public CoAPEndpointConsumerBuilder alias(String alias) {
            this.doSetProperty("alias", alias);
            return this;
        }

        default public CoAPEndpointConsumerBuilder cipherSuites(String cipherSuites) {
            this.doSetProperty("cipherSuites", cipherSuites);
            return this;
        }

        default public CoAPEndpointConsumerBuilder clientAuthentication(String clientAuthentication) {
            this.doSetProperty("clientAuthentication", clientAuthentication);
            return this;
        }

        default public CoAPEndpointConsumerBuilder privateKey(PrivateKey privateKey) {
            this.doSetProperty("privateKey", privateKey);
            return this;
        }

        default public CoAPEndpointConsumerBuilder privateKey(String privateKey) {
            this.doSetProperty("privateKey", privateKey);
            return this;
        }

        default public CoAPEndpointConsumerBuilder pskStore(PskStore pskStore) {
            this.doSetProperty("pskStore", pskStore);
            return this;
        }

        default public CoAPEndpointConsumerBuilder pskStore(String pskStore) {
            this.doSetProperty("pskStore", pskStore);
            return this;
        }

        default public CoAPEndpointConsumerBuilder publicKey(PublicKey publicKey) {
            this.doSetProperty("publicKey", publicKey);
            return this;
        }

        default public CoAPEndpointConsumerBuilder publicKey(String publicKey) {
            this.doSetProperty("publicKey", publicKey);
            return this;
        }

        default public CoAPEndpointConsumerBuilder recommendedCipherSuitesOnly(boolean recommendedCipherSuitesOnly) {
            this.doSetProperty("recommendedCipherSuitesOnly", recommendedCipherSuitesOnly);
            return this;
        }

        default public CoAPEndpointConsumerBuilder recommendedCipherSuitesOnly(String recommendedCipherSuitesOnly) {
            this.doSetProperty("recommendedCipherSuitesOnly", recommendedCipherSuitesOnly);
            return this;
        }

        default public CoAPEndpointConsumerBuilder sslContextParameters(SSLContextParameters sslContextParameters) {
            this.doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }

        default public CoAPEndpointConsumerBuilder sslContextParameters(String sslContextParameters) {
            this.doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }

        default public CoAPEndpointConsumerBuilder trustedRpkStore(TrustedRpkStore trustedRpkStore) {
            this.doSetProperty("trustedRpkStore", trustedRpkStore);
            return this;
        }

        default public CoAPEndpointConsumerBuilder trustedRpkStore(String trustedRpkStore) {
            this.doSetProperty("trustedRpkStore", trustedRpkStore);
            return this;
        }
    }
}

