/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.es;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.core.ClearScrollRequest;
import co.elastic.clients.elasticsearch.core.ScrollRequest;
import co.elastic.clients.elasticsearch.core.ScrollResponse;
import co.elastic.clients.elasticsearch.core.SearchRequest;
import co.elastic.clients.elasticsearch.core.SearchResponse;
import co.elastic.clients.elasticsearch.core.search.Hit;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.camel.Exchange;

public class ElasticsearchScrollRequestIterator<TDocument>
implements Iterator<Hit<TDocument>>,
Closeable {
    private final SearchRequest searchRequest;
    private final ElasticsearchClient esClient;
    private final Class<TDocument> documentClass;
    private Iterator<? extends Hit<TDocument>> currentSearchHits;
    private final int scrollKeepAliveMs;
    private final Exchange exchange;
    private String scrollId;
    private boolean closed;
    private int requestCount;

    public ElasticsearchScrollRequestIterator(SearchRequest.Builder searchRequestBuilder, ElasticsearchClient esClient, int scrollKeepAliveMs, Exchange exchange, Class<TDocument> documentClass) {
        this.searchRequest = searchRequestBuilder.scroll(Time.of(b -> b.time(String.format("%sms", scrollKeepAliveMs)))).build();
        this.esClient = esClient;
        this.scrollKeepAliveMs = scrollKeepAliveMs;
        this.exchange = exchange;
        this.closed = false;
        this.requestCount = 0;
        this.documentClass = documentClass;
        this.setFirstCurrentSearchHits();
    }

    @Override
    public boolean hasNext() {
        if (this.closed) {
            return false;
        }
        boolean hasNext = this.currentSearchHits.hasNext();
        if (!hasNext) {
            this.updateCurrentSearchHits();
            hasNext = this.currentSearchHits.hasNext();
        }
        return hasNext;
    }

    @Override
    public Hit<TDocument> next() {
        return this.closed ? null : this.currentSearchHits.next();
    }

    private void updateCurrentSearchHits() {
        ScrollResponse<TDocument> scrollResponse = this.scrollSearch();
        this.currentSearchHits = scrollResponse.hits().hits().iterator();
    }

    private void setFirstCurrentSearchHits() {
        SearchResponse<TDocument> searchResponse = this.firstSearch();
        this.currentSearchHits = searchResponse.hits().hits().iterator();
        this.scrollId = searchResponse.scrollId();
    }

    private SearchResponse<TDocument> firstSearch() {
        SearchResponse searchResponse;
        try {
            searchResponse = this.esClient.search(this.searchRequest, this.documentClass);
            ++this.requestCount;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return searchResponse;
    }

    private ScrollResponse<TDocument> scrollSearch() {
        ScrollResponse scrollResponse;
        try {
            ScrollRequest searchScrollRequest = new ScrollRequest.Builder().scroll(Time.of(b -> b.time(String.format("%sms", this.scrollKeepAliveMs)))).scrollId(this.scrollId).build();
            scrollResponse = this.esClient.scroll(searchScrollRequest, this.documentClass);
            ++this.requestCount;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return scrollResponse;
    }

    @Override
    public void close() {
        if (!this.closed) {
            try {
                ClearScrollRequest clearScrollRequest = new ClearScrollRequest.Builder().scrollId(List.of(this.scrollId)).build();
                this.esClient.clearScroll(clearScrollRequest);
                this.closed = true;
                this.exchange.setProperty("CamelElasticsearchScrollQueryCount", (Object)this.requestCount);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public int getRequestCount() {
        return this.requestCount;
    }

    public boolean isClosed() {
        return this.closed;
    }
}

