/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ehcache.processor.idempotent;

import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.component.ehcache.EhcacheManager;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.service.ServiceSupport;
import org.ehcache.Cache;
import org.ehcache.CacheManager;

@Metadata(label="bean", description="Idempotent repository that uses EHCache cache to store message ids.", annotations={"interfaceName=org.apache.camel.spi.IdempotentRepository"})
@Configurer(metadataOnly=true)
@ManagedResource(description="EHCache based message id repository")
public class EhcacheIdempotentRepository
extends ServiceSupport
implements IdempotentRepository {
    @Metadata(description="Name of cache", defaultValue="EhcacheIdempotentRepository")
    private String cacheName;
    private Cache<String, Boolean> cache;
    private EhcacheManager cacheManager;

    public EhcacheIdempotentRepository(CacheManager cacheManager) {
        this(cacheManager, EhcacheIdempotentRepository.class.getSimpleName());
    }

    public EhcacheIdempotentRepository(CacheManager cacheManager, String repositoryName) {
        this.cacheName = repositoryName;
        this.cacheManager = new EhcacheManager(cacheManager, false, null);
    }

    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    @ManagedAttribute(description="The processor name")
    public String getCacheName() {
        return this.cacheName;
    }

    @ManagedOperation(description="Adds the key to the store")
    public boolean add(String key) {
        return this.cache.putIfAbsent((Object)key, (Object)false) == null;
    }

    public boolean confirm(String key) {
        return this.cache.replace((Object)key, (Object)false, (Object)true);
    }

    @ManagedOperation(description="Does the store contain the given key")
    public boolean contains(String key) {
        return this.cache.containsKey((Object)key);
    }

    @ManagedOperation(description="Remove the key from the store")
    public boolean remove(String key) {
        this.cache.remove((Object)key);
        return true;
    }

    @ManagedOperation(description="Clear the store")
    public void clear() {
        this.cache.clear();
    }

    protected void doStart() throws Exception {
        this.cacheManager.start();
        this.cache = this.cacheManager.getCache(this.cacheName, String.class, Boolean.class);
    }

    protected void doStop() throws Exception {
        this.cacheManager.stop();
    }
}

