/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dynamicrouter.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.function.Supplier;
import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Message;
import org.apache.camel.Predicate;
import org.apache.camel.component.dynamicrouter.filter.PrioritizedFilter;
import org.apache.camel.component.dynamicrouter.filter.PrioritizedFilterStatistics;
import org.apache.camel.component.dynamicrouter.routing.DynamicRouterConstants;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicRouterFilterService {
    private static final Logger LOG = LoggerFactory.getLogger(DynamicRouterFilterService.class);
    private final Map<String, ConcurrentSkipListSet<PrioritizedFilter>> filterMap = new ConcurrentHashMap<String, ConcurrentSkipListSet<PrioritizedFilter>>();
    private final Map<String, List<PrioritizedFilterStatistics>> filterStatisticsMap = new ConcurrentHashMap<String, List<PrioritizedFilterStatistics>>();
    private final Supplier<PrioritizedFilter.PrioritizedFilterFactory> filterFactorySupplier;

    public DynamicRouterFilterService() {
        this.filterFactorySupplier = DynamicRouterConstants.FILTER_FACTORY_SUPPLIER;
        LOG.debug("Created Dynamic Router component");
    }

    public DynamicRouterFilterService(Supplier<PrioritizedFilter.PrioritizedFilterFactory> filterFactorySupplier) {
        this.filterFactorySupplier = filterFactorySupplier;
        LOG.debug("Created Dynamic Router component");
    }

    public void initializeChannelFilters(String channel) {
        this.filterMap.computeIfAbsent(channel, c -> new ConcurrentSkipListSet<PrioritizedFilter>(DynamicRouterConstants.FILTER_COMPARATOR));
        this.filterStatisticsMap.computeIfAbsent(channel, c -> Collections.synchronizedList(new ArrayList()));
    }

    public Collection<PrioritizedFilter> getFiltersForChannel(String channel) {
        return List.copyOf((Collection)this.filterMap.get(channel));
    }

    public Map<String, ConcurrentSkipListSet<PrioritizedFilter>> getFilterMap() {
        return Map.copyOf(this.filterMap);
    }

    public List<PrioritizedFilterStatistics> getStatisticsForChannel(String channel) {
        return List.copyOf((Collection)this.filterStatisticsMap.get(channel));
    }

    public Map<String, List<PrioritizedFilterStatistics>> getFilterStatisticsMap() {
        return Map.copyOf(this.filterStatisticsMap);
    }

    public PrioritizedFilter createFilter(String id, int priority, Predicate predicate, String endpoint, PrioritizedFilterStatistics statistics) {
        return this.filterFactorySupplier.get().getInstance(id, priority, predicate, endpoint, statistics);
    }

    public String addFilterForChannel(String id, int priority, Predicate predicate, String endpoint, String channel, boolean update) {
        return this.addFilterForChannel(this.createFilter(id, priority, predicate, endpoint, new PrioritizedFilterStatistics(id)), channel, update);
    }

    public String addFilterForChannel(PrioritizedFilter filter, String channel, boolean update) {
        boolean okToAdd;
        boolean filterExists = !this.filterMap.isEmpty() && this.filterMap.get(channel).stream().anyMatch(f -> filter.id().equals(f.id()));
        boolean bl = okToAdd = update == filterExists;
        if (okToAdd) {
            Set filters = this.filterMap.computeIfAbsent(channel, c -> new ConcurrentSkipListSet<PrioritizedFilter>(DynamicRouterConstants.FILTER_COMPARATOR));
            filters.add(filter);
            List filterStatistics = this.filterStatisticsMap.computeIfAbsent(channel, c -> Collections.synchronizedList(new ArrayList()));
            filterStatistics.add(filter.statistics());
            LOG.debug("Added subscription: {}", (Object)filter);
            return filter.id();
        }
        return String.format("Error: Filter could not be %s -- existing filter found with matching ID: %b", update ? "updated" : "added", filterExists);
    }

    public PrioritizedFilter getFilterById(String filterId, String channel) {
        return (ObjectHelper.isEmpty((String)channel) ? this.filterMap.values().stream().flatMap(Collection::stream) : this.filterMap.get(channel).stream()).filter(f -> filterId.equals(f.id())).findFirst().orElseThrow(() -> new IllegalArgumentException("No filter exists with ID: " + filterId));
    }

    public boolean removeFilterById(String filterId, String channel) {
        String routerChannel;
        String string = routerChannel = ObjectHelper.isEmpty((String)channel) ? this.filterMap.keySet().stream().filter(ch -> this.filterMap.get(ch).stream().anyMatch(f -> filterId.equals(f.id()))).findFirst().orElseThrow(() -> new IllegalArgumentException("No filter exists with ID: " + filterId)) : channel;
        if (this.filterMap.get(routerChannel).removeIf(f -> filterId.equals(f.id()))) {
            LOG.debug("Removed subscription: {}", (Object)filterId);
            return true;
        }
        LOG.debug("No subscription exists with ID: {}", (Object)filterId);
        return false;
    }

    public String getMatchingEndpointsForExchangeByChannel(Exchange exchange, String channel, boolean firstMatchOnly, boolean warnDroppedMessage) {
        String recipients;
        ArrayList<String> matchingEndpoints = new ArrayList<String>();
        for (PrioritizedFilter filter : this.filterMap.get(channel)) {
            if (!filter.predicate().matches(exchange)) continue;
            matchingEndpoints.add(filter.endpoint());
            filter.statistics().incrementCount();
            if (!firstMatchOnly) continue;
            break;
        }
        if (ObjectHelper.isEmpty((String)(recipients = String.join((CharSequence)",", matchingEndpoints)))) {
            Message message = exchange.getMessage();
            message.setHeader("originalBody", message.getBody());
            recipients = String.format("log:%s.%s?level=%s&showAll=true&multiline=true", this.getClass().getCanonicalName(), channel, warnDroppedMessage ? LoggingLevel.WARN : LoggingLevel.DEBUG);
            String error = String.format("DynamicRouter channel '%s': no filters matched for an exchange from route: '%s'.  The 'originalBody' header contains the original message body.", channel, exchange.getFromEndpoint());
            message.setBody((Object)error, String.class);
        }
        return recipients;
    }

    public static class DynamicRouterFilterServiceFactory {
        public DynamicRouterFilterService getInstance(Supplier<PrioritizedFilter.PrioritizedFilterFactory> filterFactorySupplier) {
            return new DynamicRouterFilterService(filterFactorySupplier);
        }
    }
}

