/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dynamicrouter;

import java.io.Serializable;
import org.apache.camel.Predicate;

public class DynamicRouterControlMessage
implements Serializable {
    private final ControlMessageType messageType;
    private final String id;
    private final String channel;
    private final int priority;
    private final String endpoint;
    private final Predicate predicate;

    public DynamicRouterControlMessage(ControlMessageType messageType, String id, String channel, int priority, String endpoint, Predicate predicate) {
        this.messageType = messageType;
        this.id = id;
        this.channel = channel;
        this.priority = priority;
        this.endpoint = endpoint;
        this.predicate = predicate;
    }

    public ControlMessageType getMessageType() {
        return this.messageType;
    }

    public String getId() {
        return this.id;
    }

    public String getChannel() {
        return this.channel;
    }

    public int getPriority() {
        return this.priority;
    }

    public Predicate getPredicate() {
        return this.predicate;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public static enum ControlMessageType implements Serializable
    {
        SUBSCRIBE,
        UNSUBSCRIBE;

    }

    public static class UnsubscribeMessageBuilder {
        private String id;
        private String channel;

        public UnsubscribeMessageBuilder id(String id) {
            this.id = id;
            return this;
        }

        public UnsubscribeMessageBuilder channel(String channel) {
            this.channel = channel;
            return this;
        }

        public DynamicRouterControlMessage build() {
            if (this.id == null || this.id.isEmpty() || this.channel == null || this.channel.isEmpty()) {
                throw new IllegalArgumentException("Unsubscribe messages must be created with an id and a channel");
            }
            return new DynamicRouterControlMessage(ControlMessageType.UNSUBSCRIBE, this.id, this.channel, 0, null, null);
        }
    }

    public static class SubscribeMessageBuilder {
        private String id;
        private String channel;
        private int priority;
        private String endpoint;
        private Predicate predicate;

        public SubscribeMessageBuilder id(String id) {
            this.id = id;
            return this;
        }

        public SubscribeMessageBuilder channel(String channel) {
            this.channel = channel;
            return this;
        }

        public SubscribeMessageBuilder priority(int priority) {
            this.priority = priority;
            return this;
        }

        public SubscribeMessageBuilder endpointUri(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public SubscribeMessageBuilder predicate(Predicate predicate) {
            this.predicate = predicate;
            return this;
        }

        public DynamicRouterControlMessage build() {
            if (this.id == null || this.id.isEmpty() || this.channel == null || this.channel.isEmpty() || this.endpoint == null || this.endpoint.isEmpty() || this.predicate == null) {
                throw new IllegalArgumentException("Unsubscribe messages must be created with an id, a channel, an endpoint URI, and a predicate");
            }
            return new DynamicRouterControlMessage(ControlMessageType.SUBSCRIBE, this.id, this.channel, this.priority, this.endpoint, this.predicate);
        }
    }
}

