/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dynamicrouter.control;

import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.DeferredContextBinding;
import org.apache.camel.Exchange;
import org.apache.camel.Predicate;
import org.apache.camel.TypeConversionException;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.dynamicrouter.control.DynamicRouterControlService;
import org.apache.camel.spi.BulkTypeConverters;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.spi.TypeConvertible;

@DeferredContextBinding
public final class DynamicRouterControlServiceBulkConverterLoader
implements TypeConverterLoader,
BulkTypeConverters,
CamelContextAware {
    private CamelContext camelContext;

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public int size() {
        return 1;
    }

    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        registry.addBulkTypeConverters((BulkTypeConverters)this);
        this.doRegistration(registry);
    }

    public <T> T convertTo(Class<?> from, Class<T> to, Exchange exchange, Object value) throws TypeConversionException {
        try {
            Object obj = this.doConvertTo(from, to, exchange, value);
            return (T)obj;
        }
        catch (TypeConversionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TypeConversionException(value, to, (Throwable)e);
        }
    }

    private Object doConvertTo(Class<?> from, Class<?> to, Exchange exchange, Object value) throws Exception {
        if (to == Predicate.class && value instanceof String) {
            return DynamicRouterControlService.obtainPredicateFromBeanName((String)value, this.camelContext);
        }
        return null;
    }

    private void doRegistration(TypeConverterRegistry registry) {
        registry.addConverter(new TypeConvertible(String.class, Predicate.class), (TypeConverter)this);
    }

    public TypeConverter lookup(Class<?> to, Class<?> from) {
        if (to == Predicate.class && from == String.class) {
            return this;
        }
        return null;
    }
}

