/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dynamicrouter.control;

import org.apache.camel.Predicate;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;

@UriParams
public class DynamicRouterControlConfiguration {
    @UriPath(label="control", enums="subscribe,unsubscribe", description="Control channel action: subscribe or unsubscribe")
    @Metadata(required=true)
    private String controlAction;
    @UriParam(label="control", description="The channel to subscribe to")
    private String subscribeChannel;
    @UriParam(label="control", description="The subscription ID; if unspecified, one will be assigned and returned.")
    private String subscriptionId;
    @UriParam(label="control", description="The destination URI for exchanges that match.")
    private String destinationUri;
    @UriParam(label="control", description="The subscription priority.")
    private Integer priority;
    @UriParam(label="control", description="The subscription predicate.")
    private String predicate;
    @UriParam(label="control", description="A Predicate instance in the registry.", javaType="org.apache.camel.Predicate")
    private Predicate predicateBean;
    @UriParam(label="control", defaultValue="simple", description="The subscription predicate language.")
    private String expressionLanguage = "simple";

    public String getControlAction() {
        return this.controlAction;
    }

    public String getControlActionOrDefault() {
        return this.controlAction == null ? "subscribe" : this.controlAction;
    }

    public void setControlAction(String controlAction) {
        this.controlAction = controlAction;
    }

    public String getSubscribeChannel() {
        return this.subscribeChannel;
    }

    public void setSubscribeChannel(String subscribeChannel) {
        this.subscribeChannel = subscribeChannel;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public void setSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
    }

    public String getDestinationUri() {
        return this.destinationUri;
    }

    public void setDestinationUri(String destinationUri) {
        this.destinationUri = destinationUri;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public String getPredicate() {
        return this.predicate;
    }

    public void setPredicate(String predicate) {
        this.predicate = predicate;
    }

    public Predicate getPredicateBean() {
        return this.predicateBean;
    }

    public void setPredicateBean(Predicate predicateBean) {
        this.predicateBean = predicateBean;
    }

    public String getExpressionLanguage() {
        return this.expressionLanguage;
    }

    public void setExpressionLanguage(String expressionLanguage) {
        this.expressionLanguage = expressionLanguage;
    }
}

