/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dynamicrouter.routing;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.dynamicrouter.routing.DynamicRouterComponent;
import org.apache.camel.component.dynamicrouter.routing.DynamicRouterConfiguration;
import org.apache.camel.component.dynamicrouter.routing.DynamicRouterEndpoint;
import org.apache.camel.component.dynamicrouter.routing.DynamicRouterProcessor;
import org.apache.camel.support.DefaultAsyncProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicRouterProducer
extends DefaultAsyncProducer {
    private static final Logger LOG = LoggerFactory.getLogger(DynamicRouterProducer.class);
    private final DynamicRouterComponent component;
    private final DynamicRouterConfiguration configuration;

    public DynamicRouterProducer(DynamicRouterEndpoint endpoint, DynamicRouterComponent component, DynamicRouterConfiguration configuration) {
        super((Endpoint)endpoint);
        this.component = component;
        this.configuration = configuration;
        LOG.debug("Created producer for endpoint '{}', channel '{}'", (Object)endpoint.getEndpointUri(), (Object)configuration.getChannel());
    }

    public void process(Exchange exchange) throws Exception {
        this.component.getRoutingProcessor(this.configuration.getChannel()).process(exchange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(Exchange exchange, AsyncCallback callback) {
        DynamicRouterProcessor routingProcessor = this.component.getRoutingProcessor(this.configuration.getChannel());
        if (this.configuration.isSynchronous()) {
            try {
                routingProcessor.process(exchange);
            }
            catch (Exception e) {
                exchange.setException((Throwable)e);
            }
            finally {
                callback.done(true);
            }
            return true;
        }
        return routingProcessor.process(exchange, callback);
    }

    public static class DynamicRouterProducerFactory {
        public DynamicRouterProducer getInstance(DynamicRouterEndpoint endpoint, DynamicRouterComponent component, DynamicRouterConfiguration configuration) {
            return new DynamicRouterProducer(endpoint, component, configuration);
        }
    }
}

