/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dynamicrouter.control;

import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.Predicate;
import org.apache.camel.component.dynamicrouter.control.DynamicRouterControlEndpoint;
import org.apache.camel.component.dynamicrouter.control.DynamicRouterControlProducer;
import org.apache.camel.component.dynamicrouter.control.DynamicRouterControlService;
import org.apache.camel.spi.Metadata;

public final class DynamicRouterControlConstants {
    public static final String FIRST_VERSION_CONTROL = "4.4.0";
    public static final String COMPONENT_SCHEME_CONTROL = "dynamic-router-control";
    public static final Pattern CONTROL_URI_BASE_PATTERN = Pattern.compile("^dynamic-router-control:");
    public static final Function<String, Matcher> OPTIMIZE_MATCHER = CONTROL_URI_BASE_PATTERN::matcher;
    public static final java.util.function.Predicate<String> SHOULD_OPTIMIZE = uri -> OPTIMIZE_MATCHER.apply((String)uri).find();
    public static final String CONTROL_CHANNEL_URI = "dynamic-router-control";
    public static final String TITLE_CONTROL = "Dynamic Router Control";
    public static final String SYNTAX_CONTROL = "dynamic-router-control:controlAction";
    public static final String CONTROL_ACTION_SUBSCRIBE = "subscribe";
    public static final String CONTROL_ACTION_UNSUBSCRIBE = "unsubscribe";
    public static final String CONTROL_ACTION_UPDATE = "update";
    public static final String CONTROL_ACTION_LIST = "list";
    public static final String CONTROL_ACTION_STATS = "statistics";
    public static final String SIMPLE_LANGUAGE = "simple";
    public static final String ERROR_PREDICATE_CLASS = "To supply a predicate in the message body, the body's class must be resolvable to " + Predicate.class.getCanonicalName();
    public static final String ERROR_INVALID_PREDICATE_EXPRESSION = "Language '%s' and predicate expression '%s' could not create a valid predicate";
    public static final String ERROR_NO_PREDICATE_BEAN_FOUND = "Predicate bean could not be found";
    public static final String CONTROL_ACTION_PROPERTY = "controlAction";
    public static final String SUBSCRIBE_CHANNEL_PROPERTY = "subscribeChannel";
    public static final String SUBSCRIPTION_ID_PROPERTY = "subscriptionId";
    public static final String DESTINATION_URI_PROPERTY = "destinationUri";
    public static final String PRIORITY_PROPERTY = "priority";
    public static final String PREDICATE_PROPERTY = "predicate";
    public static final String PREDICATE_BEAN_PROPERTY = "predicateBean";
    public static final String EXPRESSION_LANGUAGE_PROPERTY = "expressionLanguage";
    @Metadata(description="The control action header.", javaType="String")
    public static final String CONTROL_ACTION_HEADER = "CamelDynamicRouterControlAction";
    @Metadata(description="The Dynamic Router channel that the subscriber is subscribing on.", javaType="String")
    public static final String CONTROL_SUBSCRIBE_CHANNEL = "CamelDynamicRouterSubscribeChannel";
    @Metadata(description="The subscription ID.", javaType="String")
    public static final String CONTROL_SUBSCRIPTION_ID = "CamelDynamicRouterSubscriptionId";
    @Metadata(description="The URI on which the routing participant wants to receive matching exchanges.", javaType="String")
    public static final String CONTROL_DESTINATION_URI = "CamelDynamicRouterDestinationUri";
    @Metadata(description="The priority of this subscription", javaType="String")
    public static final String CONTROL_PRIORITY = "CamelDynamicRouterPriority";
    @Metadata(description="The predicate to evaluate exchanges for this subscription", javaType="String")
    public static final String CONTROL_PREDICATE = "CamelDynamicRouterPredicate";
    @Metadata(description="The name of the bean in the registry that identifies the subscription predicate.", javaType="String")
    public static final String CONTROL_PREDICATE_BEAN = "CamelDynamicRouterPredicateBean";
    @Metadata(description="The language for the predicate when supplied as a string.", javaType="String")
    public static final String CONTROL_EXPRESSION_LANGUAGE = "CamelDynamicRouterExpressionLanguage";
    public static final Map<String, String> URI_PARAMS_TO_HEADER_NAMES = Map.of("controlAction", "CamelDynamicRouterControlAction", "subscribeChannel", "CamelDynamicRouterSubscribeChannel", "subscriptionId", "CamelDynamicRouterSubscriptionId", "destinationUri", "CamelDynamicRouterDestinationUri", "priority", "CamelDynamicRouterPriority", "predicate", "CamelDynamicRouterPredicate", "predicateBean", "CamelDynamicRouterPredicateBean", "expressionLanguage", "CamelDynamicRouterExpressionLanguage");
    public static final Supplier<DynamicRouterControlEndpoint.DynamicRouterControlEndpointFactory> CONTROL_ENDPOINT_FACTORY_SUPPLIER = DynamicRouterControlEndpoint.DynamicRouterControlEndpointFactory::new;
    public static final Supplier<DynamicRouterControlProducer.DynamicRouterControlProducerFactory> CONTROL_PRODUCER_FACTORY_SUPPLIER = DynamicRouterControlProducer.DynamicRouterControlProducerFactory::new;
    public static final Supplier<DynamicRouterControlService.DynamicRouterControlServiceFactory> CONTROL_SERVICE_FACTORY_SUPPLIER = DynamicRouterControlService.DynamicRouterControlServiceFactory::new;

    private DynamicRouterControlConstants() {
    }
}

