/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.modeline;

import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.dsl.modeline.DependencyTrait;
import org.apache.camel.dsl.modeline.EnvTrait;
import org.apache.camel.dsl.modeline.ModelineParser;
import org.apache.camel.dsl.modeline.NameTrait;
import org.apache.camel.dsl.modeline.Trait;
import org.apache.camel.spi.CamelContextCustomizer;
import org.apache.camel.spi.Resource;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.StringQuoteHelper;

public class DefaultModelineParser
implements ModelineParser {
    public static final String MODELINE_START = "camel-k:";
    public static final String JBANG_DEPS_START = "//DEPS";
    private final Map<String, Trait> traits = new HashMap<String, Trait>();

    public DefaultModelineParser() {
        Trait trait = new DependencyTrait();
        this.traits.put(trait.getName(), trait);
        trait = new NameTrait();
        this.traits.put(trait.getName(), trait);
        trait = new EnvTrait();
        this.traits.put(trait.getName(), trait);
    }

    @Override
    public void addTrait(Trait trait) {
        this.traits.put(trait.getName(), trait);
    }

    @Override
    public List<CamelContextCustomizer> parse(Resource resource) throws Exception {
        ArrayList<CamelContextCustomizer> answer = new ArrayList<CamelContextCustomizer>();
        if (resource.exists()) {
            try (LineNumberReader reader = new LineNumberReader(resource.getReader());){
                String line = reader.readLine();
                while (line != null) {
                    List<CamelContextCustomizer> list = this.parse(resource, line);
                    answer.addAll(list);
                    line = reader.readLine();
                }
            }
        }
        return answer;
    }

    protected List<CamelContextCustomizer> parse(Resource resource, String line) {
        if (!this.isModeline(line)) {
            return Collections.emptyList();
        }
        line = DefaultModelineParser.removeLeadingComments(line);
        ArrayList<CamelContextCustomizer> answer = new ArrayList<CamelContextCustomizer>();
        if (line.startsWith(MODELINE_START)) {
            String[] parts;
            line = line.substring(MODELINE_START.length()).trim();
            for (String part : parts = StringQuoteHelper.splitSafeQuote((String)line, (char)' ', (boolean)false)) {
                CamelContextCustomizer customizer;
                String value;
                String key = StringHelper.before((String)(part = part.trim()), (String)"=");
                Trait trait = this.parseModeline(resource, key, value = StringHelper.after((String)part, (String)"="));
                if (trait == null || (customizer = trait.parseTrait(resource, value)) == null) continue;
                answer.add(customizer);
            }
        }
        if (line.startsWith(JBANG_DEPS_START)) {
            String[] parts;
            line = line.substring(JBANG_DEPS_START.length()).trim();
            line = line.trim();
            Trait dep = this.traits.get("dependency");
            for (String part : parts = StringQuoteHelper.splitSafeQuote((String)line, (char)' ', (boolean)false)) {
                CamelContextCustomizer customizer;
                if ((part = part.trim()).endsWith("@pom") || (customizer = dep.parseTrait(resource, part)) == null) continue;
                answer.add(customizer);
            }
        }
        return answer;
    }

    @Override
    public Trait parseModeline(Resource resource, String key, String value) {
        return this.traits.get(key);
    }

    @Override
    public boolean isModeline(String line) {
        if (line == null) {
            return false;
        }
        return (line = DefaultModelineParser.removeLeadingComments(line)).startsWith(MODELINE_START) || line.startsWith(JBANG_DEPS_START);
    }

    private static String removeLeadingComments(String line) {
        if (line == null) {
            return null;
        }
        line = line.trim();
        while (!line.startsWith(JBANG_DEPS_START) && line.startsWith("/") || line.startsWith("#")) {
            line = line.substring(1);
        }
        line = line.trim();
        return line;
    }
}

