/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.modeline;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.NonManagedService;
import org.apache.camel.StaticService;
import org.apache.camel.dsl.modeline.JBangModelineParser;
import org.apache.camel.dsl.modeline.ModelineParser;
import org.apache.camel.spi.CamelContextCustomizer;
import org.apache.camel.spi.ModelineFactory;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.annotations.JdkService;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.service.ServiceSupport;

@JdkService(value="dsl-modeline-factory")
public class DefaultModelineFactory
extends ServiceSupport
implements ModelineFactory,
CamelContextAware,
NonManagedService,
StaticService {
    private CamelContext camelContext;
    private final ModelineParser jbang = new JBangModelineParser();
    private ModelineParser parser;

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public void parseModeline(Resource resource) throws Exception {
        List<CamelContextCustomizer> list;
        ArrayList<CamelContextCustomizer> customizers = new ArrayList<CamelContextCustomizer>(this.jbang.parse(resource));
        if (this.parser != null && (list = this.parser.parse(resource)) != null) {
            customizers.addAll(list);
        }
        customizers.forEach(this::onConfigureModeline);
    }

    protected void onConfigureModeline(CamelContextCustomizer customizer) {
        customizer.configure(this.camelContext);
    }

    protected void doInit() throws Exception {
        this.parser = (ModelineParser)CamelContextHelper.findSingleByType((CamelContext)this.camelContext, ModelineParser.class);
    }

    public String toString() {
        return "camel-dsl-modeline";
    }
}

