/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.dozer;

import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.TypeConversionException;
import org.apache.camel.support.TypeConverterSupport;
import org.dozer.Mapper;
import org.dozer.metadata.ClassMappingMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DozerTypeConverter
extends TypeConverterSupport {
    private static final Logger LOG = LoggerFactory.getLogger(DozerTypeConverter.class);
    private final Mapper mapper;

    public DozerTypeConverter(Mapper mapper) {
        this.mapper = mapper;
    }

    public Mapper getMapper() {
        return this.mapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T convertTo(Class<T> type, Exchange exchange, Object value) throws TypeConversionException {
        Object result;
        CamelContext context = exchange != null ? exchange.getContext() : null;
        ClassLoader appcl = context != null ? context.getApplicationContextClassLoader() : null;
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> sourceType;
            ClassMappingMetadata metadata;
            if (appcl != null && appcl != tccl) {
                LOG.debug("Switching TCCL to: {}", (Object)appcl);
                Thread.currentThread().setContextClassLoader(appcl);
            }
            String mapId = null;
            if (value != null && (metadata = this.getClassMappingMetadata(sourceType = value.getClass(), type)) != null) {
                mapId = metadata.getMapId();
            }
            result = this.mapper.map(value, type, mapId);
        }
        finally {
            if (appcl != null && appcl != tccl) {
                Thread.currentThread().setContextClassLoader(tccl);
                LOG.debug("Restored TCCL to: {}", (Object)tccl);
            }
        }
        return (T)result;
    }

    private ClassMappingMetadata getClassMappingMetadata(Class<?> sourceType, Class<?> destType) {
        ClassMappingMetadata result = null;
        for (ClassMappingMetadata aux : this.mapper.getMappingMetadata().getClassMappingsBySource(sourceType)) {
            if (!destType.isAssignableFrom(aux.getDestinationClass())) continue;
            result = aux;
            break;
        }
        return result;
    }
}

