/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.djl.model.cv;

import ai.djl.Model;
import ai.djl.inference.Predictor;
import ai.djl.modality.cv.Image;
import ai.djl.translate.TranslateException;
import ai.djl.translate.Translator;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.TypeConversionException;
import org.apache.camel.component.djl.DJLEndpoint;
import org.apache.camel.component.djl.model.AbstractPredictor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomCvPredictor<T>
extends AbstractPredictor {
    private static final Logger LOG = LoggerFactory.getLogger(CustomCvPredictor.class);
    protected final String modelName;
    protected final String translatorName;

    public CustomCvPredictor(DJLEndpoint endpoint) {
        super(endpoint);
        this.modelName = endpoint.getModel();
        this.translatorName = endpoint.getTranslator();
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        try {
            Image image = (Image)exchange.getIn().getBody(Image.class);
            T result = this.predict(exchange, image);
            exchange.getIn().setBody(result);
        }
        catch (TypeConversionException e) {
            throw new RuntimeCamelException("Data type is not supported. Body should be ai.djl.modality.cv.Image, byte[], InputStream or File");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected T predict(Exchange exchange, Image image) {
        Model model = (Model)exchange.getContext().getRegistry().lookupByNameAndType(this.modelName, Model.class);
        Translator translator = (Translator)exchange.getContext().getRegistry().lookupByNameAndType(this.translatorName, Translator.class);
        exchange.getIn().setHeader("CamelDjlInput", (Object)image);
        try (Predictor predictor = model.newPredictor(translator);){
            Object object = predictor.predict((Object)image);
            return (T)object;
        }
        catch (TranslateException e) {
            LOG.error("Could not process input or output", (Throwable)e);
            throw new RuntimeCamelException("Could not process input or output", (Throwable)e);
        }
    }
}

