/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.djl.model.cv;

import ai.djl.inference.Predictor;
import ai.djl.modality.cv.Image;
import ai.djl.repository.zoo.ZooModel;
import ai.djl.translate.TranslateException;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.TypeConversionException;
import org.apache.camel.component.djl.DJLEndpoint;
import org.apache.camel.component.djl.model.AbstractPredictor;

public abstract class AbstractCvZooPredictor<T>
extends AbstractPredictor {
    protected ZooModel<Image, T> model;

    public AbstractCvZooPredictor(DJLEndpoint endpoint) {
        super(endpoint);
    }

    @Override
    public void process(Exchange exchange) {
        try {
            Image image = (Image)exchange.getIn().getBody(Image.class);
            T result = this.predict(exchange, image);
            exchange.getIn().setBody(result);
        }
        catch (TypeConversionException e) {
            throw new RuntimeCamelException("Data type is not supported. Body should be ai.djl.modality.cv.Image, byte[], InputStream or File");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected T predict(Exchange exchange, Image image) {
        exchange.getIn().setHeader("CamelDjlInput", (Object)image);
        try (Predictor predictor = this.model.newPredictor();){
            Object object = predictor.predict((Object)image);
            return (T)object;
        }
        catch (TranslateException e) {
            throw new RuntimeCamelException("Could not process input or output", (Throwable)e);
        }
    }
}

