/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.djl.model.cv;

import ai.djl.Model;
import ai.djl.inference.Predictor;
import ai.djl.modality.cv.Image;
import ai.djl.translate.TranslateException;
import ai.djl.translate.Translator;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.djl.DJLEndpoint;
import org.apache.camel.component.djl.model.AbstractPredictor;

public class CustomImageGenerationPredictor
extends AbstractPredictor {
    private final String modelName;
    private final String translatorName;

    public CustomImageGenerationPredictor(DJLEndpoint endpoint) {
        super(endpoint);
        this.modelName = endpoint.getModel();
        this.translatorName = endpoint.getTranslator();
    }

    @Override
    public void process(Exchange exchange) {
        if (!(exchange.getIn().getBody() instanceof int[])) {
            throw new RuntimeCamelException("Data type is not supported. Body should be int[]");
        }
        int[] seed = (int[])exchange.getIn().getBody(int[].class);
        Image[] result = this.predict(exchange, seed);
        exchange.getIn().setBody((Object)result);
    }

    protected Image[] predict(Exchange exchange, int[] seed) {
        Image[] imageArray;
        block8: {
            Model model = (Model)exchange.getContext().getRegistry().lookupByNameAndType(this.modelName, Model.class);
            Translator translator = (Translator)exchange.getContext().getRegistry().lookupByNameAndType(this.translatorName, Translator.class);
            exchange.getIn().setHeader("CamelDjlInput", (Object)seed);
            Predictor predictor = model.newPredictor(translator);
            try {
                imageArray = (Image[])predictor.predict((Object)seed);
                if (predictor == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (predictor != null) {
                        try {
                            predictor.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (TranslateException e) {
                    throw new RuntimeCamelException("Could not process input or output", (Throwable)e);
                }
            }
            predictor.close();
        }
        return imageArray;
    }
}

