/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.djl.model.audio;

import ai.djl.Application;
import ai.djl.MalformedModelException;
import ai.djl.inference.Predictor;
import ai.djl.modality.audio.Audio;
import ai.djl.repository.zoo.Criteria;
import ai.djl.repository.zoo.ModelNotFoundException;
import ai.djl.repository.zoo.ModelZoo;
import ai.djl.repository.zoo.ZooModel;
import ai.djl.training.util.ProgressBar;
import ai.djl.translate.TranslateException;
import ai.djl.util.Progress;
import java.io.IOException;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.TypeConversionException;
import org.apache.camel.component.djl.DJLEndpoint;
import org.apache.camel.component.djl.model.AbstractPredictor;

public class ZooAudioPredictor
extends AbstractPredictor {
    private final ZooModel<Audio, String> model;

    public ZooAudioPredictor(DJLEndpoint endpoint) throws ModelNotFoundException, MalformedModelException, IOException {
        super(endpoint);
        Criteria.Builder builder = Criteria.builder().optApplication(Application.Audio.ANY).setTypes(Audio.class, String.class).optArtifactId(endpoint.getArtifactId());
        if (endpoint.isShowProgress()) {
            builder.optProgress((Progress)new ProgressBar());
        }
        Criteria criteria = builder.build();
        this.model = ModelZoo.loadModel((Criteria)criteria);
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        try {
            Audio audio = (Audio)exchange.getIn().getBody(Audio.class);
            String result = this.predict(exchange, audio);
            exchange.getIn().setBody((Object)result);
        }
        catch (TypeConversionException e) {
            throw new RuntimeCamelException("Data type is not supported. Body should be ai.djl.modality.audio.Audio, byte[], InputStream or File");
        }
    }

    protected String predict(Exchange exchange, Audio audio) {
        String string;
        block8: {
            exchange.getIn().setHeader("CamelDjlInput", (Object)audio);
            Predictor predictor = this.model.newPredictor();
            try {
                string = (String)predictor.predict((Object)audio);
                if (predictor == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (predictor != null) {
                        try {
                            predictor.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (TranslateException e) {
                    throw new RuntimeCamelException("Could not process input or output", (Throwable)e);
                }
            }
            predictor.close();
        }
        return string;
    }
}

