/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.directvm;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.directvm.DirectVmConsumer;
import org.apache.camel.component.directvm.DirectVmConsumerNotAvailableException;
import org.apache.camel.component.directvm.DirectVmEndpoint;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.support.DefaultAsyncProducer;

public class DirectVmProducer
extends DefaultAsyncProducer {
    private DirectVmEndpoint endpoint;

    public DirectVmProducer(DirectVmEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        Exchange submitted;
        DirectVmConsumer consumer = this.endpoint.getComponent().getConsumer(this.endpoint);
        if (consumer == null) {
            if (this.endpoint.isFailIfNoConsumers()) {
                exchange.setException((Throwable)((Object)new DirectVmConsumerNotAvailableException("No consumers available on endpoint: " + (Object)((Object)this.endpoint), exchange)));
            } else {
                this.log.debug("message ignored, no consumers available on endpoint: {}", (Object)this.endpoint);
            }
            callback.done(true);
            return true;
        }
        HeaderFilterStrategy headerFilterStrategy = this.endpoint.getHeaderFilterStrategy();
        Exchange exchange2 = submitted = !this.endpoint.isPropagateProperties() || headerFilterStrategy != null ? exchange.copy() : exchange;
        if (!this.endpoint.isPropagateProperties()) {
            submitted.getProperties().clear();
        }
        if (headerFilterStrategy != null) {
            submitted.getIn().getHeaders().entrySet().removeIf(e -> headerFilterStrategy.applyFilterToCamelHeaders((String)e.getKey(), e.getValue(), submitted));
        }
        return consumer.getAsyncProcessor().process(submitted, done -> {
            Message msg;
            Message message = msg = submitted.hasOut() ? submitted.getOut() : submitted.getIn();
            if (headerFilterStrategy != null) {
                msg.getHeaders().entrySet().removeIf(e -> headerFilterStrategy.applyFilterToExternalHeaders((String)e.getKey(), e.getValue(), submitted));
            }
            if (exchange != submitted) {
                exchange.setException((Throwable)submitted.getException());
                exchange.getOut().copyFrom(msg);
            }
            if (this.endpoint.isPropagateProperties()) {
                exchange.getProperties().putAll(submitted.getProperties());
            }
            callback.done(done);
        });
    }
}

