/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.digitalocean;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.digitalocean.DigitalOceanConfiguration;
import org.apache.camel.component.digitalocean.DigitalOceanEndpoint;
import org.apache.camel.component.digitalocean.DigitalOceanException;
import org.apache.camel.component.digitalocean.constants.DigitalOceanResources;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.ObjectHelper;

@Component(value="digitalocean")
public class DigitalOceanComponent
extends DefaultComponent {
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        DigitalOceanConfiguration configuration = new DigitalOceanConfiguration();
        configuration.setResource(DigitalOceanResources.valueOf(remaining));
        DigitalOceanEndpoint endpoint = new DigitalOceanEndpoint(uri, this, configuration);
        this.setProperties((Endpoint)endpoint, parameters);
        if (ObjectHelper.isEmpty((String)configuration.getOAuthToken()) && ObjectHelper.isEmpty((Object)configuration.getDigitalOceanClient())) {
            throw new DigitalOceanException("oAuthToken or digitalOceanClient must be specified");
        }
        return endpoint;
    }
}

