/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.dfdl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.component.dfdl.DfdlParseException;
import org.apache.camel.component.dfdl.DfdlUnparseException;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.annotations.Dataformat;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.daffodil.japi.Daffodil;
import org.apache.daffodil.japi.DataProcessor;
import org.apache.daffodil.japi.Diagnostic;
import org.apache.daffodil.japi.ParseResult;
import org.apache.daffodil.japi.ProcessorFactory;
import org.apache.daffodil.japi.UnparseResult;
import org.apache.daffodil.japi.infoset.InfosetInputter;
import org.apache.daffodil.japi.infoset.InfosetOutputter;
import org.apache.daffodil.japi.infoset.W3CDOMInfosetInputter;
import org.apache.daffodil.japi.infoset.W3CDOMInfosetOutputter;
import org.apache.daffodil.japi.io.InputSourceDataInputStream;
import org.w3c.dom.Document;

@Dataformat(value="dfdl")
public class DfdlDataFormat
extends ServiceSupport
implements DataFormat,
CamelContextAware {
    private CamelContext camelContext;
    private String schemaUri;
    private String rootElement;
    private String rootNamespace;
    private DataProcessor daffodilProcessor;

    public void marshal(Exchange exchange, Object graph, OutputStream stream) throws Exception {
        Document xmlDocument = (Document)this.camelContext.getTypeConverter().mandatoryConvertTo(Document.class, exchange, graph);
        W3CDOMInfosetInputter inputter = new W3CDOMInfosetInputter(xmlDocument);
        UnparseResult result = this.daffodilProcessor.unparse((InfosetInputter)inputter, Channels.newChannel(stream));
        if (result.isError()) {
            exchange.setException((Throwable)new DfdlUnparseException(result));
        }
    }

    public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
        InputSourceDataInputStream inputStream = new InputSourceDataInputStream(stream);
        W3CDOMInfosetOutputter outputter = new W3CDOMInfosetOutputter();
        ParseResult result = this.daffodilProcessor.parse(inputStream, (InfosetOutputter)outputter);
        if (result.isError()) {
            exchange.setException((Throwable)new DfdlParseException(result));
            return null;
        }
        return outputter.getResult();
    }

    public void doInit() throws Exception {
        super.doInit();
        Resource schemaResource = ResourceHelper.resolveMandatoryResource((CamelContext)this.getCamelContext(), (String)this.getSchemaUri());
        ProcessorFactory processorFactory = this.getRootElement() != null && !this.getRootElement().isEmpty() && this.getRootNamespace() != null && !this.getRootNamespace().isEmpty() ? Daffodil.compiler().compileSource(schemaResource.getURI(), this.getRootElement(), this.getRootNamespace()) : Daffodil.compiler().compileSource(schemaResource.getURI());
        if (processorFactory.isError()) {
            StringBuilder buf = new StringBuilder("Failed to start dfdl dataformat: [");
            for (Diagnostic d : processorFactory.getDiagnostics()) {
                buf.append(d.getMessage()).append("; ");
            }
            buf.append("]");
            throw new IOException(buf.toString());
        }
        this.daffodilProcessor = processorFactory.onPath("/");
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public String getSchemaUri() {
        return this.schemaUri;
    }

    public void setSchemaUri(String schemaUri) {
        this.schemaUri = schemaUri;
    }

    public String getRootElement() {
        return this.rootElement;
    }

    public void setRootElement(String rootElement) {
        this.rootElement = rootElement;
    }

    public String getRootNamespace() {
        return this.rootNamespace;
    }

    public void setRootNamespace(String rootNamespace) {
        this.rootNamespace = rootNamespace;
    }
}

