/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.debezium;

import org.apache.camel.spi.Metadata;
import org.apache.kafka.connect.storage.FileOffsetBackingStore;

public final class DebeziumConstants {
    public static final String DEFAULT_OFFSET_STORAGE = FileOffsetBackingStore.class.getName();
    private static final String HEADER_PREFIX = "CamelDebezium";
    @Metadata(description="The metadata about the source event, for example `table` name, database `name`, log position, etc, please refer to the Debezium documentation for more info.", javaType="Map<String, Object>")
    public static final String HEADER_SOURCE_METADATA = "CamelDebeziumSourceMetadata";
    @Metadata(description="The identifier of the connector, normally is this format \"+++{server-name}.{database-name}.{table-name}+++\".", javaType="String")
    public static final String HEADER_IDENTIFIER = "CamelDebeziumIdentifier";
    @Metadata(description="The key of the event, normally is the table Primary Key.", javaType="Struct")
    public static final String HEADER_KEY = "CamelDebeziumKey";
    @Metadata(description="If presents, the type of event operation. Values for the connector are `c` for create (or insert), `u` for update, `d` for delete or `r` for read (in the case of a initial sync) or in case of a snapshot event.", javaType="String")
    public static final String HEADER_OPERATION = "CamelDebeziumOperation";
    @Metadata(description="If presents, the time (using the system clock in the JVM) at which the connector processed the event.", javaType="Long")
    public static final String HEADER_TIMESTAMP = "CamelDebeziumTimestamp";
    @Metadata(description="If presents, contains the state of the row before the event occurred.", javaType="Struct")
    public static final String HEADER_BEFORE = "CamelDebeziumBefore";
    @Metadata(description="If presents, the ddl sql text of the event.", javaType="String")
    public static final String HEADER_DDL_SQL = "CamelDebeziumDdlSQL";

    private DebeziumConstants() {
    }
}

