/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.debezium.configuration;

import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.embedded.EmbeddedEngine;
import io.debezium.engine.spi.OffsetCommitPolicy;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.debezium.DebeziumConstants;
import org.apache.camel.component.debezium.configuration.ConfigurationValidation;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.ObjectHelper;
import org.apache.kafka.connect.json.JsonConverter;

@UriParams
public abstract class EmbeddedDebeziumConfiguration
implements Cloneable {
    private static final String LABEL_NAME = "consumer";
    private Class<?> connectorClass;
    @UriPath(label="consumer", description="Unique name for the connector. Attempting to register again with the same name will fail.")
    @Metadata(required=true)
    private String name;
    @UriParam(label="consumer", defaultValue="org.apache.kafka.connect.storage.FileOffsetBackingStore", description="The name of the Java class that is responsible for persistence of connector offsets.")
    private String offsetStorage = DebeziumConstants.DEFAULT_OFFSET_STORAGE;
    @UriParam(label="consumer", description="Path to file where offsets are to be stored. Required when offset.storage is set to the FileOffsetBackingStore.")
    private String offsetStorageFileName;
    @UriParam(label="consumer", description="The name of the Kafka topic where offsets are to be stored. Required when offset.storage is set to the KafkaOffsetBackingStore.")
    private String offsetStorageTopic;
    @UriParam(label="consumer", description="The number of partitions used when creating the offset storage topic. Required when offset.storage is set to the 'KafkaOffsetBackingStore'.")
    private int offsetStoragePartitions;
    @UriParam(label="consumer", description="Replication factor used when creating the offset storage topic. Required when offset.storage is set to the KafkaOffsetBackingStore")
    private int offsetStorageReplicationFactor;
    @UriParam(label="consumer", description="The name of the Java class of the commit policy. It defines when offsets commit has to be triggered based on the number of events processed and the time elapsed since the last commit. This class must implement the interface 'OffsetCommitPolicy'. The default is a periodic commit policy based upon time intervals.")
    private String offsetCommitPolicy = OffsetCommitPolicy.PeriodicCommitOffsetPolicy.class.getName();
    @UriParam(label="consumer", defaultValue="60000", description="Interval at which to try committing offsets. The default is 1 minute.", javaType="java.time.Duration")
    private long offsetFlushIntervalMs = 60000L;
    @UriParam(label="consumer", defaultValue="5000", description="Maximum number of milliseconds to wait for records to flush and partition offset data to be committed to offset storage before cancelling the process and restoring the offset data to be committed in a future attempt. The default is 5 seconds.", javaType="java.time.Duration")
    private long offsetCommitTimeoutMs = 5000L;
    @UriParam(label="consumer", defaultValue="org.apache.kafka.connect.json.JsonConverter", description="The Converter class that should be used to serialize and deserialize key data for offsets. The default is JSON converter.")
    private String internalKeyConverter = JsonConverter.class.getName();
    @UriParam(label="consumer", defaultValue="org.apache.kafka.connect.json.JsonConverter", description="The Converter class that should be used to serialize and deserialize value data for offsets. The default is JSON converter.")
    private String internalValueConverter = JsonConverter.class.getName();
    @UriParam(label="common", prefix="additionalProperties.", multiValue=true, description="Additional properties for debezium components in case they can't be set directly on the camel configurations (e.g: setting Kafka Connect properties needed by Debezium engine, for example setting KafkaOffsetBackingStore), the properties have to be prefixed with `additionalProperties.`. E.g: `additionalProperties.transactional.id=12345&additionalProperties.schema.registry.url=http://localhost:8811/avro`")
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public EmbeddedDebeziumConfiguration() {
        ObjectHelper.notNull(this.configureConnectorClass(), (String)"connectorClass");
        this.connectorClass = this.configureConnectorClass();
    }

    public Object copy() {
        try {
            EmbeddedDebeziumConfiguration answer = (EmbeddedDebeziumConfiguration)this.clone();
            HashMap<String, Object> additionalPropertiesCopy = new HashMap<String, Object>(this.additionalProperties);
            answer.setAdditionalProperties(additionalPropertiesCopy);
            return answer;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    protected abstract Class<?> configureConnectorClass();

    protected abstract Configuration createConnectorConfiguration();

    protected abstract ConfigurationValidation validateConnectorConfiguration();

    public abstract String getConnectorDatabaseType();

    public Configuration createDebeziumConfiguration() {
        Configuration connectorConfiguration = this.createConnectorConfiguration();
        ObjectHelper.notNull((Object)connectorConfiguration, (String)"createConnectorConfiguration");
        return ((Configuration.Builder)((Configuration.Builder)Configuration.create().with(this.createDebeziumEmbeddedEngineConfiguration())).with(this.createConnectorConfiguration())).build();
    }

    private Configuration createDebeziumEmbeddedEngineConfiguration() {
        Configuration.Builder configBuilder = Configuration.create();
        EmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, EmbeddedEngine.ENGINE_NAME, this.name);
        EmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, EmbeddedEngine.CONNECTOR_CLASS, this.connectorClass.getName());
        EmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, EmbeddedEngine.OFFSET_STORAGE, this.offsetStorage);
        EmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, EmbeddedEngine.OFFSET_STORAGE_FILE_FILENAME, this.offsetStorageFileName);
        EmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, EmbeddedEngine.OFFSET_STORAGE_KAFKA_TOPIC, this.offsetStorageTopic);
        EmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, EmbeddedEngine.OFFSET_STORAGE_KAFKA_PARTITIONS, Integer.valueOf(this.offsetStoragePartitions));
        EmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, EmbeddedEngine.OFFSET_STORAGE_KAFKA_REPLICATION_FACTOR, Integer.valueOf(this.offsetStorageReplicationFactor));
        EmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, EmbeddedEngine.OFFSET_COMMIT_POLICY, this.offsetCommitPolicy);
        EmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, EmbeddedEngine.OFFSET_FLUSH_INTERVAL_MS, Long.valueOf(this.offsetFlushIntervalMs));
        EmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, EmbeddedEngine.OFFSET_COMMIT_TIMEOUT_MS, Long.valueOf(this.offsetCommitTimeoutMs));
        if (this.internalKeyConverter != null && this.internalValueConverter != null) {
            configBuilder.with("internal.key.converter", this.internalKeyConverter);
            configBuilder.with("internal.value.converter", this.internalValueConverter);
        }
        this.applyAdditionalProperties(configBuilder, this.getAdditionalProperties());
        return configBuilder.build();
    }

    protected static <T> void addPropertyIfNotNull(Configuration.Builder configBuilder, Field field, T value) {
        if (value != null) {
            configBuilder.with(field, value);
        }
    }

    protected static <T> void addPropertyIfNotNull(Configuration.Builder configBuilder, String key, T value) {
        if (value != null) {
            configBuilder.with(key, value);
        }
    }

    private void applyAdditionalProperties(Configuration.Builder configBuilder, Map<String, Object> additionalProperties) {
        if (!ObjectHelper.isEmpty(this.getAdditionalProperties())) {
            additionalProperties.forEach((property, value) -> EmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, property, value));
        }
    }

    public ConfigurationValidation validateConfiguration() {
        ConfigurationValidation embeddedEngineValidation = this.validateDebeziumEmbeddedEngineConfiguration();
        if (embeddedEngineValidation.isValid()) {
            ConfigurationValidation connectorValidation = this.validateConnectorConfiguration();
            ObjectHelper.notNull((Object)connectorValidation, (String)"validateConnectorConfiguration");
            return connectorValidation;
        }
        return embeddedEngineValidation;
    }

    private ConfigurationValidation validateDebeziumEmbeddedEngineConfiguration() {
        if (EmbeddedDebeziumConfiguration.isFieldValueNotSet(this.name)) {
            return ConfigurationValidation.notValid("Required field 'name' must be set.");
        }
        if (this.offsetStorage.equals(DebeziumConstants.DEFAULT_OFFSET_STORAGE) && EmbeddedDebeziumConfiguration.isFieldValueNotSet(this.offsetStorageFileName)) {
            return ConfigurationValidation.notValid(String.format("Required field 'offsetStorageFileName' must be set since 'offsetStorage' is set to '%s'", DebeziumConstants.DEFAULT_OFFSET_STORAGE));
        }
        return ConfigurationValidation.valid();
    }

    protected static boolean isFieldValueNotSet(Object field) {
        return ObjectHelper.isEmpty((Object)field);
    }

    public Class<?> getConnectorClass() {
        return this.connectorClass;
    }

    public void setConnectorClass(Class<?> connectorClass) {
        this.connectorClass = connectorClass;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getOffsetStorage() {
        return this.offsetStorage;
    }

    public void setOffsetStorage(String offsetStorage) {
        this.offsetStorage = offsetStorage;
    }

    public String getOffsetStorageFileName() {
        return this.offsetStorageFileName;
    }

    public void setOffsetStorageFileName(String offsetStorageFileName) {
        this.offsetStorageFileName = offsetStorageFileName;
    }

    public String getOffsetStorageTopic() {
        return this.offsetStorageTopic;
    }

    public void setOffsetStorageTopic(String offsetStorageTopic) {
        this.offsetStorageTopic = offsetStorageTopic;
    }

    public int getOffsetStorageReplicationFactor() {
        return this.offsetStorageReplicationFactor;
    }

    public void setOffsetStorageReplicationFactor(int offsetStorageReplicationFactor) {
        this.offsetStorageReplicationFactor = offsetStorageReplicationFactor;
    }

    public String getOffsetCommitPolicy() {
        return this.offsetCommitPolicy;
    }

    public void setOffsetCommitPolicy(String offsetCommitPolicy) {
        this.offsetCommitPolicy = offsetCommitPolicy;
    }

    public long getOffsetFlushIntervalMs() {
        return this.offsetFlushIntervalMs;
    }

    public void setOffsetFlushIntervalMs(long offsetFlushIntervalMs) {
        this.offsetFlushIntervalMs = offsetFlushIntervalMs;
    }

    public long getOffsetCommitTimeoutMs() {
        return this.offsetCommitTimeoutMs;
    }

    public void setOffsetCommitTimeoutMs(long offsetCommitTimeoutMs) {
        this.offsetCommitTimeoutMs = offsetCommitTimeoutMs;
    }

    public int getOffsetStoragePartitions() {
        return this.offsetStoragePartitions;
    }

    public void setOffsetStoragePartitions(int offsetStoragePartitions) {
        this.offsetStoragePartitions = offsetStoragePartitions;
    }

    public String getInternalKeyConverter() {
        return this.internalKeyConverter;
    }

    public void setInternalKeyConverter(String internalKeyConverter) {
        this.internalKeyConverter = internalKeyConverter;
    }

    public String getInternalValueConverter() {
        return this.internalValueConverter;
    }

    public void setInternalValueConverter(String internalValueConverter) {
        this.internalValueConverter = internalValueConverter;
    }

    public void setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }
}

