/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dapr.operations;

import io.dapr.client.DaprClient;
import java.util.EnumMap;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.component.dapr.DaprConfigurationOptionsProxy;
import org.apache.camel.component.dapr.DaprOperation;
import org.apache.camel.component.dapr.operations.DaprConfigurationHandler;
import org.apache.camel.component.dapr.operations.DaprInvokeBindingHandler;
import org.apache.camel.component.dapr.operations.DaprOperationHandler;
import org.apache.camel.component.dapr.operations.DaprOperationResponse;
import org.apache.camel.component.dapr.operations.DaprPubSubHandler;
import org.apache.camel.component.dapr.operations.DaprServiceInvocationHandler;
import org.apache.camel.component.dapr.operations.DaprStateHandler;

public class DaprOperationManager {
    private final DaprConfigurationOptionsProxy configurationOptionsProxy;
    private final Map<DaprOperation, DaprOperationHandler> handlerMap = new EnumMap<DaprOperation, DaprOperationHandler>(DaprOperation.class);

    public DaprOperationManager(DaprConfigurationOptionsProxy configurationOptionsProxy) {
        this.configurationOptionsProxy = configurationOptionsProxy;
        this.handlerMap.put(DaprOperation.invokeService, new DaprServiceInvocationHandler(configurationOptionsProxy));
        this.handlerMap.put(DaprOperation.state, new DaprStateHandler(configurationOptionsProxy));
        this.handlerMap.put(DaprOperation.pubSub, new DaprPubSubHandler(configurationOptionsProxy));
        this.handlerMap.put(DaprOperation.invokeBinding, new DaprInvokeBindingHandler(configurationOptionsProxy));
        this.handlerMap.put(DaprOperation.configuration, new DaprConfigurationHandler(configurationOptionsProxy));
    }

    public DaprOperationResponse process(Exchange exchange, DaprClient client) throws Exception {
        DaprOperation operation = this.configurationOptionsProxy.getOperation();
        DaprOperationHandler handler = this.handlerMap.get((Object)operation);
        if (handler == null) {
            throw new UnsupportedOperationException("No handler for operation " + String.valueOf((Object)operation));
        }
        handler.validateConfiguration(exchange);
        return handler.handle(exchange, client);
    }
}

