/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dapr;

import io.dapr.client.domain.HttpExtension;
import io.dapr.client.domain.State;
import io.dapr.client.domain.StateOptions;
import io.dapr.client.domain.TransactionalStateOperation;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.camel.Exchange;
import org.apache.camel.component.dapr.DaprConfiguration;
import org.apache.camel.component.dapr.DaprExchangeHeaders;
import org.apache.camel.component.dapr.DaprOperation;
import org.apache.camel.component.dapr.StateOperation;
import org.apache.camel.util.ObjectHelper;

public class DaprConfigurationOptionsProxy {
    private final DaprConfiguration configuration;

    public DaprConfigurationOptionsProxy(DaprConfiguration config) {
        this.configuration = config;
    }

    public DaprOperation getOperation() {
        return this.configuration.getOperation();
    }

    public String getServiceToInvoke(Exchange exchange) {
        return this.getOption(DaprExchangeHeaders::getServiceToInvokeFromHeaders, this.configuration::getServiceToInvoke, exchange);
    }

    public String getMethodToInvoke(Exchange exchange) {
        return this.getOption(DaprExchangeHeaders::getMethodToInvokeFromHeaders, this.configuration::getMethodToInvoke, exchange);
    }

    public String getVerb(Exchange exchange) {
        return this.getOption(DaprExchangeHeaders::getVerbFromHeaders, this.configuration::getVerb, exchange);
    }

    public Map<String, List<String>> getQueryParameters(Exchange exchange) {
        return this.getOption(DaprExchangeHeaders::getQueryParametersFromHeaders, () -> null, exchange);
    }

    public Map<String, String> getHttpHeaders(Exchange exchange) {
        return this.getOption(DaprExchangeHeaders::getHttpHeadersFromHeaders, () -> null, exchange);
    }

    public HttpExtension getHttpExtension(Exchange exchange) {
        return this.getOption(DaprExchangeHeaders::getHttpExtensionFromHeaders, this.configuration::getHttpExtension, exchange);
    }

    public StateOperation getStateOperation(Exchange exchange) {
        return this.getOption(DaprExchangeHeaders::getStateOperationFromHeaders, this.configuration::getStateOperation, exchange);
    }

    public String getStateStore(Exchange exchange) {
        return this.getOption(DaprExchangeHeaders::getStateStoreFromHeaders, this.configuration::getStateStore, exchange);
    }

    public String getSecretStore(Exchange exchange) {
        return this.getOption(DaprExchangeHeaders::getSecretStoreFromHeaders, this.configuration::getSecretStore, exchange);
    }

    public String getConfigStore(Exchange exchange) {
        return this.getOption(DaprExchangeHeaders::getConfigStoreFromHeaders, this.configuration::getConfigStore, exchange);
    }

    public String getKey(Exchange exchange) {
        return this.getOption(DaprExchangeHeaders::getKeyFromHeaders, this.configuration::getKey, exchange);
    }

    public String getETag(Exchange exchange) {
        return this.getOption(DaprExchangeHeaders::getETagFromHeaders, this.configuration::getETag, exchange);
    }

    public StateOptions.Concurrency getConcurrency(Exchange exchange) {
        return this.getOption(DaprExchangeHeaders::getConcurrencyFromHeaders, this.configuration::getConcurrency, exchange);
    }

    public StateOptions.Consistency getConsistency(Exchange exchange) {
        return this.getOption(DaprExchangeHeaders::getConsistencyFromHeaders, this.configuration::getConsistency, exchange);
    }

    public Map<String, String> getMetadata(Exchange exchange) {
        return this.getOption(DaprExchangeHeaders::getMetadataFromHeaders, () -> null, exchange);
    }

    public List<State<?>> getStates(Exchange exchange) {
        return this.getOption(DaprExchangeHeaders::getStatesFromHeaders, () -> null, exchange);
    }

    public List<String> getKeys(Exchange exchange) {
        return this.getOption(DaprExchangeHeaders::getKeysFromHeaders, () -> null, exchange);
    }

    public List<TransactionalStateOperation<?>> getTransactions(Exchange exchange) {
        return this.getOption(DaprExchangeHeaders::getTransactionsFromHeaders, () -> null, exchange);
    }

    public String getPubSubName(Exchange exchange) {
        return this.getOption(DaprExchangeHeaders::getPubSubNameFromHeaders, this.configuration::getPubSubName, exchange);
    }

    public String getTopic(Exchange exchange) {
        return this.getOption(DaprExchangeHeaders::getTopicFromHeaders, this.configuration::getTopic, exchange);
    }

    public String getContentType(Exchange exchange) {
        return this.getOption(DaprExchangeHeaders::getContentTypeFromHeaders, this.configuration::getContentType, exchange);
    }

    public String getBindingName(Exchange exchange) {
        return this.getOption(DaprExchangeHeaders::getBindingNameFromHeaders, this.configuration::getBindingName, exchange);
    }

    public String getBindingOperation(Exchange exchange) {
        return this.getOption(DaprExchangeHeaders::getBindingOperationFromHeaders, this.configuration::getBindingOperation, exchange);
    }

    public String getConfigKeys(Exchange exchange) {
        return this.getOption(DaprExchangeHeaders::getConfigKeysFromHeaders, this.configuration::getConfigKeys, exchange);
    }

    public List<String> getConfigKeysAsList(Exchange exchange) {
        return this.configuration.getConfigKeysAsList();
    }

    private <R> R getOption(Function<Exchange, R> exchangeFn, Supplier<R> fallbackFn, Exchange exchange) {
        return ObjectHelper.isEmpty((Object)exchange) || ObjectHelper.isEmpty(exchangeFn.apply(exchange)) ? fallbackFn.get() : exchangeFn.apply(exchange);
    }
}

