/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dapr;

import io.dapr.client.DaprClient;
import io.dapr.client.DaprClientBuilder;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.dapr.DaprComponent;
import org.apache.camel.component.dapr.DaprConfiguration;
import org.apache.camel.component.dapr.DaprConstants;
import org.apache.camel.component.dapr.DaprOperation;
import org.apache.camel.component.dapr.DaprProducer;
import org.apache.camel.component.dapr.consumer.DaprConfigurationConsumer;
import org.apache.camel.component.dapr.consumer.DaprPubSubConsumer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;

@UriEndpoint(firstVersion="4.12.0", scheme="dapr", title="Dapr", syntax="dapr:operation", category={Category.CLOUD, Category.SAAS}, headersClass=DaprConstants.class)
public class DaprEndpoint
extends DefaultEndpoint {
    @UriParam
    private DaprConfiguration configuration;
    private DaprClient client;

    public DaprEndpoint(String uri, DaprComponent component, DaprConfiguration configuration) {
        super(uri, (Component)component);
        this.configuration = configuration;
    }

    public Producer createProducer() throws Exception {
        return new DaprProducer((Endpoint)this, this.configuration);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        DaprOperation operation = this.configuration.getOperation();
        switch (operation) {
            case pubSub: {
                return new DaprPubSubConsumer(this, processor);
            }
            case configuration: {
                return new DaprConfigurationConsumer(this, processor);
            }
        }
        throw new IllegalArgumentException("Cannot create Dapr consumer with type " + String.valueOf((Object)operation));
    }

    public void doStart() throws Exception {
        super.doStart();
        this.client = new DaprClientBuilder().build();
    }

    public DaprConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(DaprConfiguration config) {
        this.configuration = config;
    }

    public DaprClient getClient() {
        return this.client;
    }
}

