/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dapr;

import io.dapr.client.DaprPreviewClient;
import io.dapr.client.domain.HttpExtension;
import io.dapr.client.domain.StateOptions;
import java.util.List;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.dapr.DaprOperation;
import org.apache.camel.component.dapr.StateOperation;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;

@UriParams
public class DaprConfiguration
implements Cloneable {
    @UriPath(label="producer", enums="invokeService, state")
    @Metadata(required=true)
    private DaprOperation operation;
    @UriParam(label="producer", description="Target service to invoke. Can be a Dapr App ID, a named HTTPEndpoint, or a FQDN/public URL")
    private String serviceToInvoke;
    @UriParam(label="producer", description="The name of the method or route to invoke on the target service")
    private String methodToInvoke;
    @UriParam(label="producer", description="The HTTP verb to use for invoking the method", defaultValue="POST")
    private String verb = "POST";
    @UriParam(label="producer", description="HTTP method to use when invoking the service. Accepts verbs like GET, POST, PUT, DELETE, etc. Creates a minimal HttpExtension with no headers or query params. Takes precedence over verb")
    @Metadata(autowired=true)
    private HttpExtension httpExtension;
    @UriParam(label="producer", enums="save, saveBulk, get, getBulk, delete, executeTransaction", defaultValue="get", description="The state operation to perform on the state store. Required for DaprOperation.state operation")
    private StateOperation stateOperation = StateOperation.get;
    @UriParam(label="producer", description="The name of the Dapr state store to interact with, defined in statestore.yaml config")
    private String stateStore;
    @UriParam(label="producer", description="The name of the Dapr secret store to interact with, defined in local-secret-store.yaml config")
    private String secretStore;
    @UriParam(label="common", description="The name of the Dapr configuration store to interact with, defined in statestore.yaml config")
    private String configStore;
    @UriParam(label="producer", description="The key used to identify the state/secret object within the specified state/secret store")
    private String key;
    @UriParam(label="producer", description="The eTag for optimistic concurrency during state save or delete operations")
    private String eTag;
    @UriParam(label="producer", description="Concurrency mode to use with state operations", enums="FIRST_WRITE, LAST_WRITE")
    private StateOptions.Concurrency concurrency;
    @UriParam(label="producer", description="Consistency level to use with state operations", enums="EVENTUAL, STRONG")
    private StateOptions.Consistency consistency;
    @UriParam(label="consumer", description="The client to consume messages by the consumer")
    @Metadata(autowired=true)
    private DaprPreviewClient previewClient;
    @UriParam(label="common", description="The name of the Dapr Pub/Sub component to use. This identifies which underlying messaging system Dapr will interact with for publishing or subscribing to events.")
    private String pubSubName;
    @UriParam(label="common", description="The name of the topic to subscribe to. The topic must exist in the Pub/Sub component configured under the given pubsubName.")
    private String topic;
    @UriParam(label="common", description="The contentType for the Pub/Sub component to use.")
    private String contentType;
    @UriParam(label="producer", description="The name of the Dapr binding to invoke")
    private String bindingName;
    @UriParam(label="producer", description="The operation to perform on the binding")
    private String bindingOperation;
    @UriParam(label="common", description="List of keys for configuration operation")
    private String configKeys;

    public DaprOperation getOperation() {
        return this.operation;
    }

    public void setOperation(DaprOperation operation) {
        this.operation = operation;
    }

    public String getServiceToInvoke() {
        return this.serviceToInvoke;
    }

    public void setServiceToInvoke(String serviceToInvoke) {
        this.serviceToInvoke = serviceToInvoke;
    }

    public String getMethodToInvoke() {
        return this.methodToInvoke;
    }

    public void setMethodToInvoke(String methodToInvoke) {
        this.methodToInvoke = methodToInvoke;
    }

    public String getVerb() {
        return this.verb;
    }

    public void setVerb(String verb) {
        this.verb = verb;
    }

    public HttpExtension getHttpExtension() {
        return this.httpExtension;
    }

    public void setHttpExtension(HttpExtension httpExtension) {
        this.httpExtension = httpExtension;
    }

    public StateOperation getStateOperation() {
        return this.stateOperation;
    }

    public void setStateOperation(StateOperation stateOperation) {
        this.stateOperation = stateOperation;
    }

    public String getStateStore() {
        return this.stateStore;
    }

    public void setStateStore(String stateStore) {
        this.stateStore = stateStore;
    }

    public String getSecretStore() {
        return this.secretStore;
    }

    public void setSecretStore(String secretStore) {
        this.secretStore = secretStore;
    }

    public String getConfigStore() {
        return this.configStore;
    }

    public void setConfigStore(String configStore) {
        this.configStore = configStore;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getETag() {
        return this.eTag;
    }

    public void setETag(String eTag) {
        this.eTag = eTag;
    }

    public StateOptions.Concurrency getConcurrency() {
        return this.concurrency;
    }

    public void setConcurrency(StateOptions.Concurrency concurrency) {
        this.concurrency = concurrency;
    }

    public StateOptions.Consistency getConsistency() {
        return this.consistency;
    }

    public void setConsistency(StateOptions.Consistency consistency) {
        this.consistency = consistency;
    }

    public String getPubSubName() {
        return this.pubSubName;
    }

    public void setPubSubName(String pubSubName) {
        this.pubSubName = pubSubName;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public DaprPreviewClient getPreviewClient() {
        return this.previewClient;
    }

    public void setPreviewClient(DaprPreviewClient previewClient) {
        this.previewClient = previewClient;
    }

    public String getBindingName() {
        return this.bindingName;
    }

    public void setBindingName(String bindingName) {
        this.bindingName = bindingName;
    }

    public String getBindingOperation() {
        return this.bindingOperation;
    }

    public void setBindingOperation(String bindingOperation) {
        this.bindingOperation = bindingOperation;
    }

    public String getConfigKeys() {
        return this.configKeys;
    }

    public List<String> getConfigKeysAsList() {
        if (this.configKeys != null) {
            return List.of(this.configKeys.split(","));
        }
        return null;
    }

    public void setConfigKeys(String configKeys) {
        this.configKeys = configKeys;
    }

    public DaprConfiguration copy() {
        try {
            return (DaprConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }
}

