/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dapr.operations;

import io.dapr.client.DaprClient;
import io.dapr.client.domain.InvokeBindingRequest;
import io.dapr.utils.TypeRef;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.component.dapr.DaprConfigurationOptionsProxy;
import org.apache.camel.component.dapr.operations.DaprOperationHandler;
import org.apache.camel.component.dapr.operations.DaprOperationResponse;
import org.apache.camel.util.ObjectHelper;

public class DaprInvokeBindingHandler
implements DaprOperationHandler {
    private final DaprConfigurationOptionsProxy configurationOptionsProxy;

    public DaprInvokeBindingHandler(DaprConfigurationOptionsProxy configurationOptionsProxy) {
        this.configurationOptionsProxy = configurationOptionsProxy;
    }

    @Override
    public DaprOperationResponse handle(Exchange exchange, DaprClient client) {
        Object payload = exchange.getIn().getBody();
        String bindingName = this.configurationOptionsProxy.getBindingName(exchange);
        String bindingOperation = this.configurationOptionsProxy.getBindingOperation(exchange);
        Map<String, String> metadata = this.configurationOptionsProxy.getMetadata(exchange);
        InvokeBindingRequest bindingRequest = new InvokeBindingRequest(bindingName, bindingOperation);
        bindingRequest.setData(payload);
        bindingRequest.setMetadata(metadata);
        byte[] response = (byte[])client.invokeBinding(bindingRequest, TypeRef.get(byte[].class)).block();
        return DaprOperationResponse.create(response);
    }

    @Override
    public void validateConfiguration(Exchange exchange) {
        String bindingName = this.configurationOptionsProxy.getBindingName(exchange);
        String bindingOperation = this.configurationOptionsProxy.getBindingOperation(exchange);
        if (ObjectHelper.isEmpty((String)bindingName) || ObjectHelper.isEmpty((String)bindingOperation)) {
            throw new IllegalArgumentException("bindingName and bindingOperation are mandatory to invoke binding");
        }
    }
}

