/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dapr.consumer;

import io.dapr.client.DaprClient;
import io.dapr.client.domain.SubscribeConfigurationRequest;
import io.dapr.client.domain.SubscribeConfigurationResponse;
import java.util.HashMap;
import java.util.List;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.dapr.DaprEndpoint;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

public class DaprConfigurationConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(DaprConfigurationConsumer.class);
    private final String configStore;
    private final List<String> configKeys;
    private final DaprClient client;
    private String subscriptionId;

    public DaprConfigurationConsumer(DaprEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.configStore = endpoint.getConfiguration().getConfigStore();
        this.configKeys = endpoint.getConfiguration().getConfigKeys();
        this.client = endpoint.getClient();
    }

    protected void doInit() throws Exception {
        super.doInit();
        if (ObjectHelper.isEmpty((String)this.configStore) || ObjectHelper.isEmpty(this.configKeys)) {
            throw new IllegalArgumentException("configStore and configKeys are mandatory for subscribe configuration operation");
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        LOG.debug("Creating connection to Dapr Configuration");
        SubscribeConfigurationRequest configRequest = new SubscribeConfigurationRequest(this.configStore, this.configKeys);
        Flux subscription = this.client.subscribeConfiguration(configRequest);
        subscription.subscribe(response -> {
            if (response.getItems() == null || response.getItems().isEmpty()) {
                this.subscriptionId = response.getSubscriptionId();
                LOG.debug("App subscribed to config changes with subscription id: {}", (Object)this.subscriptionId);
            } else {
                Exchange exchange = this.createServiceBusExchange((SubscribeConfigurationResponse)response);
                AsyncCallback cb = this.defaultConsumerCallback(exchange, true);
                this.getAsyncProcessor().process(exchange, cb);
            }
        });
    }

    protected void doStop() throws Exception {
        if (this.client != null) {
            this.client.unsubscribeConfiguration(this.subscriptionId, this.configStore);
            this.client.close();
        }
        super.doStop();
    }

    public DaprEndpoint getEndpoint() {
        return (DaprEndpoint)super.getEndpoint();
    }

    private Exchange createServiceBusExchange(SubscribeConfigurationResponse response) {
        Exchange exchange = this.createExchange(true);
        Message message = exchange.getIn();
        HashMap body = new HashMap();
        response.getItems().forEach((k, v) -> body.put(k, v.getValue()));
        message.setBody(body);
        message.setHeader("CamelDaprSubscriptionId", (Object)response.getSubscriptionId());
        message.setHeader("CamelDaprRawConfigResponse", (Object)response.getItems());
        return exchange;
    }
}

