/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.interceptors;

import org.apache.camel.component.cxf.util.CxfUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.OutgoingChainInterceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.model.BindingOperationInfo;

public class UnitOfWorkCloserInterceptor
extends AbstractPhaseInterceptor<Message> {
    boolean handleOneWayMessage;

    public UnitOfWorkCloserInterceptor(String phase, boolean handleOneWayMessage) {
        super(phase);
        if (phase.equals("post-invoke")) {
            this.addAfter(OutgoingChainInterceptor.class.getName());
        }
        this.handleOneWayMessage = handleOneWayMessage;
    }

    public UnitOfWorkCloserInterceptor() {
        super("post-logical-ending");
    }

    public void handleMessage(Message message) throws Fault {
        if (this.handleOneWayMessage) {
            if (this.isOneWay(message)) {
                CxfUtils.closeCamelUnitOfWork(message);
            }
        } else {
            CxfUtils.closeCamelUnitOfWork(message);
        }
    }

    private boolean isOneWay(Message message) {
        Exchange ex = message.getExchange();
        BindingOperationInfo binding = ex.getBindingOperationInfo();
        return null != binding && null != binding.getOperationInfo() && binding.getOperationInfo().isOneWay();
    }
}

