/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.cxf.CxfEndpoint;
import org.apache.camel.impl.HeaderFilterStrategyComponent;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.IntrospectionSupport;

public class CxfComponent
extends HeaderFilterStrategyComponent {
    Boolean allowStreaming;

    public CxfComponent() {
        super(CxfEndpoint.class);
    }

    public CxfComponent(CamelContext context) {
        super(context, CxfEndpoint.class);
    }

    public void setAllowStreaming(Boolean b) {
        this.allowStreaming = b;
    }

    public Boolean getAllowStreaming() {
        return this.allowStreaming;
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        CxfEndpoint result = null;
        if (this.allowStreaming != null && !parameters.containsKey("allowStreaming")) {
            parameters.put("allowStreaming", Boolean.toString(this.allowStreaming));
        }
        if (remaining.startsWith("bean:")) {
            String beanId = remaining.substring("bean:".length());
            if (beanId.startsWith("//")) {
                beanId = beanId.substring(2);
            }
            result = (CxfEndpoint)CamelContextHelper.mandatoryLookup((CamelContext)this.getCamelContext(), (String)beanId, CxfEndpoint.class);
            if (this.getCamelContext().equals(result.getCamelContext())) {
                result.setCamelContext(this.getCamelContext());
            }
        } else {
            result = new CxfEndpoint(remaining, this);
        }
        if (result.getCamelContext() == null) {
            result.setCamelContext(this.getCamelContext());
        }
        this.setEndpointHeaderFilterStrategy((Endpoint)result);
        this.setProperties(result, parameters);
        Map properties = IntrospectionSupport.extractProperties(parameters, (String)"properties.");
        if (properties != null) {
            result.setProperties(properties);
        }
        if (result.getProperties() != null) {
            result.setMtomEnabled(Boolean.valueOf((String)result.getProperties().get("mtom-enabled")));
        }
        return result;
    }

    protected void afterConfiguration(String uri, String remaining, Endpoint endpoint, Map<String, Object> parameters) throws Exception {
        CxfEndpoint cxfEndpoint = (CxfEndpoint)endpoint;
        cxfEndpoint.updateEndpointUri(uri);
    }
}

