/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.jaxws;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.SSLContextParametersAware;
import org.apache.camel.component.cxf.jaxws.CxfEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.HeaderFilterStrategyComponent;
import org.apache.camel.util.PropertiesHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@org.apache.camel.spi.annotations.Component(value="cxf")
public class CxfComponent
extends HeaderFilterStrategyComponent
implements SSLContextParametersAware {
    private static final Logger LOG = LoggerFactory.getLogger(CxfComponent.class);
    @Metadata(label="advanced")
    private Boolean allowStreaming;
    @Metadata(label="security", defaultValue="false")
    private boolean useGlobalSslContextParameters;
    private Map<String, BeanCacheEntry> beanCache = new HashMap<String, BeanCacheEntry>();

    public CxfComponent() {
    }

    public CxfComponent(CamelContext context) {
        super(context);
    }

    public void setAllowStreaming(Boolean allowStreaming) {
        this.allowStreaming = allowStreaming;
    }

    public Boolean getAllowStreaming() {
        return this.allowStreaming;
    }

    public boolean isUseGlobalSslContextParameters() {
        return this.useGlobalSslContextParameters;
    }

    public void setUseGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
        this.useGlobalSslContextParameters = useGlobalSslContextParameters;
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        CxfEndpoint result;
        Object value = parameters.remove("setDefaultBus");
        if (value != null) {
            LOG.warn("The option setDefaultBus is @deprecated, use name defaultBus instead");
            if (!parameters.containsKey("defaultBus")) {
                parameters.put("defaultBus", value);
            }
        }
        if (this.allowStreaming != null && !parameters.containsKey("allowStreaming")) {
            parameters.put("allowStreaming", Boolean.toString(this.allowStreaming));
        }
        if (remaining.startsWith("bean:")) {
            String beanId = remaining.substring("bean:".length());
            if (beanId.startsWith("//")) {
                beanId = beanId.substring(2);
            }
            result = this.createCxfSpringEndpoint(beanId);
            result.setBeanId(beanId);
            if (this.beanCache.containsKey(beanId)) {
                BeanCacheEntry entry = this.beanCache.get(beanId);
                if (entry.cxfEndpoint == result && !entry.parameters.equals(parameters)) {
                    throw new RuntimeException("Different URI refer to the same CxfEndpoint Bean instance with ID : " + beanId + " but with different parameters. Please use the proper Bean scope ");
                }
            } else {
                this.beanCache.put(beanId, new BeanCacheEntry(result, new HashMap<String, Object>(parameters)));
            }
        } else {
            result = this.createCxfEndpoint(remaining);
        }
        result.setComponent((Component)this);
        result.setCamelContext(this.getCamelContext());
        this.setEndpointHeaderFilterStrategy((Endpoint)result);
        this.setProperties((Endpoint)result, parameters);
        Map properties = PropertiesHelper.extractProperties(parameters, (String)"properties.");
        result.setProperties(properties);
        if (result.getSslContextParameters() == null) {
            result.setSslContextParameters(this.retrieveGlobalSslContextParameters());
        }
        return result;
    }

    protected CxfEndpoint createCxfSpringEndpoint(String beanId) {
        return (CxfEndpoint)CamelContextHelper.mandatoryLookup((CamelContext)this.getCamelContext(), (String)beanId, CxfEndpoint.class);
    }

    protected CxfEndpoint createCxfEndpoint(String remaining) {
        return new CxfEndpoint(remaining, this);
    }

    protected void afterConfiguration(String uri, String remaining, Endpoint endpoint, Map<String, Object> parameters) throws Exception {
        CxfEndpoint cxfEndpoint = (CxfEndpoint)endpoint;
        cxfEndpoint.updateEndpointUri(uri);
    }

    class BeanCacheEntry {
        CxfEndpoint cxfEndpoint;
        Map<String, Object> parameters;

        BeanCacheEntry(CxfEndpoint cxfEndpoint, Map<String, Object> parameters) {
            this.cxfEndpoint = cxfEndpoint;
            this.parameters = parameters;
        }
    }
}

