/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.jaxws;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class CxfEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":beanId:address";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;
    private static final Map<String, String> MULTI_VALUE_PREFIXES;

    public boolean isEnabled(String scheme) {
        return "cxf".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax = scheme + BASE;
        Object uri = syntax;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, (String)uri, "beanId", null, false, copy);
        uri = this.buildPathParameter(syntax, (String)uri, "address", null, false, copy);
        uri = this.buildQueryParameters((String)uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public Map<String, String> multiValuePrefixes() {
        return MULTI_VALUE_PREFIXES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(38);
        props.add("address");
        props.add("allowStreaming");
        props.add("beanId");
        props.add("bindingId");
        props.add("bridgeErrorHandler");
        props.add("bus");
        props.add("continuationTimeout");
        props.add("cookieHandler");
        props.add("cxfBinding");
        props.add("cxfConfigurer");
        props.add("dataFormat");
        props.add("defaultBus");
        props.add("defaultOperationName");
        props.add("defaultOperationNamespace");
        props.add("exceptionHandler");
        props.add("exchangePattern");
        props.add("headerFilterStrategy");
        props.add("hostnameVerifier");
        props.add("lazyStartProducer");
        props.add("loggingFeatureEnabled");
        props.add("loggingSizeLimit");
        props.add("mergeProtocolHeaders");
        props.add("mtomEnabled");
        props.add("password");
        props.add("portName");
        props.add("properties");
        props.add("publishedEndpointUrl");
        props.add("schemaValidationEnabled");
        props.add("serviceClass");
        props.add("serviceName");
        props.add("skipFaultLogging");
        props.add("skipPayloadMessagePartCheck");
        props.add("sslContextParameters");
        props.add("synchronous");
        props.add("username");
        props.add("wrapped");
        props.add("wrappedStyle");
        props.add("wsdlURL");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(2);
        secretProps.add("password");
        secretProps.add("username");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
        HashMap<String, String> prefixes = new HashMap<String, String>(1);
        prefixes.put("properties", "properties.");
        MULTI_VALUE_PREFIXES = Collections.unmodifiableMap(prefixes);
    }
}

