/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.jaxrs;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class CxfRsEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":beanId:address";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;
    private static final Set<String> MULTI_VALUE_PREFIXES;

    public boolean isEnabled(String scheme) {
        return "cxfrs".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax = scheme + BASE;
        Object uri = syntax;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, (String)uri, "beanId", null, false, copy);
        uri = this.buildPathParameter(syntax, (String)uri, "address", null, false, copy);
        uri = this.buildQueryParameters((String)uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public Set<String> multiValuePrefixes() {
        return MULTI_VALUE_PREFIXES;
    }

    public boolean isLenientProperties() {
        return true;
    }

    static {
        HashSet<String> props = new HashSet<String>(33);
        props.add("address");
        props.add("beanId");
        props.add("binding");
        props.add("bindingStyle");
        props.add("bridgeErrorHandler");
        props.add("bus");
        props.add("continuationTimeout");
        props.add("cookieHandler");
        props.add("cxfRsConfigurer");
        props.add("defaultBus");
        props.add("exceptionHandler");
        props.add("exchangePattern");
        props.add("features");
        props.add("headerFilterStrategy");
        props.add("hostnameVerifier");
        props.add("httpClientAPI");
        props.add("ignoreDeleteMethodMessageBody");
        props.add("lazyStartProducer");
        props.add("loggingFeatureEnabled");
        props.add("loggingSizeLimit");
        props.add("maxClientCacheSize");
        props.add("modelRef");
        props.add("performInvocation");
        props.add("propagateContexts");
        props.add("providers");
        props.add("publishedEndpointUrl");
        props.add("resourceClasses");
        props.add("schemaLocations");
        props.add("serviceBeans");
        props.add("skipFaultLogging");
        props.add("sslContextParameters");
        props.add("synchronous");
        props.add("throwExceptionOnFailure");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        SECRET_PROPERTY_NAMES = Collections.emptySet();
        MULTI_VALUE_PREFIXES = Collections.emptySet();
    }
}

